/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.gerrit;

import com.google.common.base.MoreObjects;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.sonargerrit.SonarToGerritPublisher;
import org.jenkinsci.plugins.sonargerrit.gerrit.ReviewCommentType;
import org.jenkinsci.plugins.sonargerrit.sonar.IssueFilterConfig;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ReviewConfig
extends AbstractDescribableImpl<ReviewConfig> {
    private ReviewCommentType commentType = DescriptorImpl.DEFAULT_COMMENT_TYPE;
    @Nonnull
    private IssueFilterConfig issueFilterConfig = new IssueFilterConfig();
    @Nonnull
    private String someIssuesTitleTemplate = DescriptorImpl.SOME_ISSUES_TITLE_TEMPLATE;
    @Nonnull
    private String noIssuesTitleTemplate = DescriptorImpl.NO_ISSUES_TITLE_TEMPLATE;
    @Nonnull
    private String issueCommentTemplate = DescriptorImpl.ISSUE_COMMENT_TEMPLATE;

    public ReviewConfig(IssueFilterConfig issueFilterConfig, String noIssuesTitleTemplate, String someIssuesTitleTemplate, String issueCommentTemplate) {
        this.setIssueFilterConfig(issueFilterConfig);
        this.setNoIssuesTitleTemplate(noIssuesTitleTemplate);
        this.setSomeIssuesTitleTemplate(someIssuesTitleTemplate);
        this.setIssueCommentTemplate(issueCommentTemplate);
    }

    @DataBoundConstructor
    public ReviewConfig() {
        this(new IssueFilterConfig(), DescriptorImpl.NO_ISSUES_TITLE_TEMPLATE, DescriptorImpl.SOME_ISSUES_TITLE_TEMPLATE, DescriptorImpl.ISSUE_COMMENT_TEMPLATE);
    }

    public ReviewCommentType getCommentType() {
        return Optional.ofNullable(this.commentType).orElse(DescriptorImpl.DEFAULT_COMMENT_TYPE);
    }

    @DataBoundSetter
    public void setCommentType(ReviewCommentType commentType) {
        this.commentType = Optional.ofNullable(commentType).orElse(DescriptorImpl.DEFAULT_COMMENT_TYPE);
    }

    public IssueFilterConfig getIssueFilterConfig() {
        return this.issueFilterConfig;
    }

    @DataBoundSetter
    public void setIssueFilterConfig(IssueFilterConfig issueFilterConfig) {
        this.issueFilterConfig = (IssueFilterConfig)((Object)MoreObjects.firstNonNull((Object)((Object)issueFilterConfig), (Object)((Object)new IssueFilterConfig())));
    }

    @Nonnull
    public String getSomeIssuesTitleTemplate() {
        return this.someIssuesTitleTemplate;
    }

    @DataBoundSetter
    public void setSomeIssuesTitleTemplate(String someIssuesTitleTemplate) {
        this.someIssuesTitleTemplate = (String)MoreObjects.firstNonNull((Object)Util.fixEmptyAndTrim((String)someIssuesTitleTemplate), (Object)DescriptorImpl.SOME_ISSUES_TITLE_TEMPLATE);
    }

    @Nonnull
    public String getNoIssuesTitleTemplate() {
        return this.noIssuesTitleTemplate;
    }

    @DataBoundSetter
    public void setNoIssuesTitleTemplate(String noIssuesTitleTemplate) {
        this.noIssuesTitleTemplate = (String)MoreObjects.firstNonNull((Object)Util.fixEmptyAndTrim((String)noIssuesTitleTemplate), (Object)DescriptorImpl.NO_ISSUES_TITLE_TEMPLATE);
    }

    @Nonnull
    public String getIssueCommentTemplate() {
        return this.issueCommentTemplate;
    }

    @DataBoundSetter
    public void setIssueCommentTemplate(String issueCommentTemplate) {
        this.issueCommentTemplate = (String)MoreObjects.firstNonNull((Object)Util.fixEmptyAndTrim((String)issueCommentTemplate), (Object)DescriptorImpl.ISSUE_COMMENT_TEMPLATE);
    }

    public DescriptorImpl getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ReviewConfig> {
        public static final ReviewCommentType DEFAULT_COMMENT_TYPE = ReviewCommentType.STANDARD;
        public static final String NO_ISSUES_TITLE_TEMPLATE = SonarToGerritPublisher.DescriptorImpl.NO_ISSUES_TEXT;
        public static final String SOME_ISSUES_TITLE_TEMPLATE = SonarToGerritPublisher.DescriptorImpl.SOME_ISSUES_TEXT;
        public static final String ISSUE_COMMENT_TEMPLATE = SonarToGerritPublisher.DescriptorImpl.ISSUE_COMMENT_TEXT;

        public String getCommentTypeDisplayName(ReviewCommentType commentType) {
            return commentType.displayName();
        }

        public FormValidation doCheckNoIssuesTitleTemplate(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckSomeIssuesTitleTemplate(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckIssueCommentTemplate(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public String getDisplayName() {
            return "ReviewConfig";
        }
    }
}

