/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.gerrit;

import com.cloudbees.plugins.credentials.common.PasswordCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernameCredentials;
import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritManagement;
import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.List;
import java.util.Optional;
import org.jenkinsci.plugins.sonargerrit.gerrit.GerritHttpCredentials;
import org.jenkinsci.plugins.sonargerrit.util.Localization;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GerritAuthenticationConfig
extends AbstractDescribableImpl<GerritAuthenticationConfig> {
    private transient String username;
    private transient Secret password;
    private String httpCredentialsId;

    @DataBoundConstructor
    public GerritAuthenticationConfig() {
    }

    protected Object readResolve() {
        if (this.username != null || this.password != null) {
            this.httpCredentialsId = GerritHttpCredentials.get().migrate(this.username, this.password).orElse(null);
            this.username = null;
            this.password = null;
        }
        return this;
    }

    @DataBoundSetter
    public void setHttpCredentialsId(String httpCredentialsId) {
        this.httpCredentialsId = httpCredentialsId;
    }

    @Nullable
    public String getHttpCredentialsId() {
        return this.httpCredentialsId;
    }

    @Deprecated
    @DataBoundSetter
    public void setUsername(String username) {
        this.httpCredentialsId = GerritHttpCredentials.get().migrate(username, this.getSecretPassword()).orElse(null);
    }

    @Deprecated
    @DataBoundSetter
    public void setPassword(String password) {
        this.setSecretPassword(Secret.fromString((String)password));
    }

    @Deprecated
    @DataBoundSetter
    public void setSecretPassword(Secret secretPassword) {
        this.httpCredentialsId = GerritHttpCredentials.get().migrate(this.getUsername(), secretPassword).orElse(null);
    }

    @Deprecated
    @Nullable
    public String getUsername() {
        return this.getHttpCredentials(null).map(UsernameCredentials::getUsername).orElse(null);
    }

    @Deprecated
    @Nullable
    public String getPassword() {
        return this.getHttpCredentials(null).map(PasswordCredentials::getPassword).map(Secret::getPlainText).map(Util::fixEmpty).orElse(null);
    }

    @Deprecated
    public Secret getSecretPassword() {
        return this.getHttpCredentials(null).map(PasswordCredentials::getPassword).orElse(null);
    }

    public Optional<StandardUsernamePasswordCredentials> getHttpCredentials(@Nullable Item requester) {
        return GerritHttpCredentials.get().findById(requester, this.httpCredentialsId);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GerritAuthenticationConfig> {
        public ListBoxModel doFillHttpCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            return GerritHttpCredentials.get().listCredentials(item, credentialsId);
        }

        public FormValidation doTestConnection(@AncestorInPath Item item, @QueryParameter(value="httpCredentialsId") String httpCredentialsId, @QueryParameter(value="serverName") String serverName) {
            FormValidation credentialsIdRequiredValidation = FormValidation.validateRequired((String)httpCredentialsId);
            if (credentialsIdRequiredValidation.kind == FormValidation.Kind.ERROR) {
                return credentialsIdRequiredValidation;
            }
            StandardUsernamePasswordCredentials credentials = GerritHttpCredentials.get().findById(item, httpCredentialsId).orElse(null);
            if (credentials == null) {
                return FormValidation.error((String)Localization.getLocalized("jenkins.plugin.error.gerrit.http.credentials.id.not-found"));
            }
            IGerritHudsonTriggerConfig gerritConfig = GerritManagement.getConfig((String)serverName);
            if (gerritConfig == null) {
                return FormValidation.error((String)Localization.getLocalized("jenkins.plugin.error.gerrit.config.empty"));
            }
            if (!gerritConfig.isUseRestApi()) {
                return FormValidation.error((String)Localization.getLocalized("jenkins.plugin.error.gerrit.restapi.off"));
            }
            GerritServer server = PluginImpl.getServer_((String)serverName);
            if (server == null) {
                return FormValidation.error((String)Localization.getLocalized("jenkins.plugin.error.gerrit.server.empty"));
            }
            return server.getDescriptor().doTestRestConnection(gerritConfig.getGerritFrontEndUrl(), credentials.getUsername(), credentials.getPassword().getPlainText());
        }

        public List<String> getServerNames() {
            return PluginImpl.getServerNames_();
        }

        public String getDisplayName() {
            return "GerritAuthenticationConfig";
        }
    }
}

