/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.gerrit;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import org.jenkinsci.plugins.sonargerrit.sonar.ByExactSeverityPredicate;
import org.jenkinsci.plugins.sonargerrit.sonar.ByMinSeverityPredicate;
import org.jenkinsci.plugins.sonargerrit.sonar.Issue;
import org.jenkinsci.plugins.sonargerrit.sonar.Severity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class CustomReportFormatter {
    private final String successMessage;
    private final String failMessage;
    private final Iterable<Issue> issues;

    public CustomReportFormatter(Iterable<Issue> issues, String failMessage, String successMessage) {
        this.issues = issues;
        this.failMessage = failMessage;
        this.successMessage = successMessage;
    }

    public String getMessage() {
        String res = this.getSize(this.issues) > 0 ? this.failMessage : this.successMessage;
        for (Tag tag : Tag.values()) {
            res = res.replace(tag.getName(), this.getValueToReplace(tag));
        }
        return res;
    }

    private String getValueToReplace(Tag tag) {
        switch (tag) {
            case INFO_ISSUE_COUNT: 
            case MINOR_ISSUE_COUNT: 
            case MAJOR_ISSUE_COUNT: 
            case CRITICAL_ISSUE_COUNT: 
            case BLOCKER_ISSUE_COUNT: {
                int value = this.getSize(this.filterByExactSeverityPredicate(tag.getSeverity()));
                return String.valueOf(value);
            }
            case AT_LEAST_MINOR_ISSUE_COUNT: 
            case AT_LEAST_MAJOR_ISSUE_COUNT: 
            case AT_LEAST_CRITICAL_ISSUE_COUNT: 
            case TOTAL_COUNT: {
                int value = this.getSize(this.filterByMinSeverityPredicate(tag.getSeverity()));
                return String.valueOf(value);
            }
        }
        return "";
    }

    private int getSize(Iterable<?> i) {
        return Lists.newArrayList(i).size();
    }

    private Iterable<Issue> filterByExactSeverityPredicate(Severity s) {
        return Iterables.filter(this.issues, (Predicate)ByExactSeverityPredicate.apply(s));
    }

    private Iterable<Issue> filterByMinSeverityPredicate(Severity s) {
        return Iterables.filter(this.issues, (Predicate)ByMinSeverityPredicate.apply(s));
    }

    public static enum Tag {
        INFO_ISSUE_COUNT("<info_count>", Severity.INFO),
        MINOR_ISSUE_COUNT("<minor_count>", Severity.MINOR),
        MAJOR_ISSUE_COUNT("<major_count>", Severity.MAJOR),
        CRITICAL_ISSUE_COUNT("<critical_count>", Severity.CRITICAL),
        BLOCKER_ISSUE_COUNT("<blocker_count>", Severity.BLOCKER),
        AT_LEAST_MINOR_ISSUE_COUNT("<min_minor_count>", Severity.MINOR),
        AT_LEAST_MAJOR_ISSUE_COUNT("<min_major_count>", Severity.MAJOR),
        AT_LEAST_CRITICAL_ISSUE_COUNT("<min_critical_count>", Severity.CRITICAL),
        TOTAL_COUNT("<total_count>", Severity.INFO);

        private final String name;
        private final Severity severity;

        private Tag(String name, Severity severity) {
            this.name = name;
            this.severity = severity;
        }

        public String getName() {
            return this.name;
        }

        public Severity getSeverity() {
            return this.severity;
        }
    }
}

