/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.gerrit;

import org.jenkinsci.plugins.sonargerrit.sonar.Issue;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class CustomIssueFormatter {
    private final Issue issue;
    private final String text;

    public CustomIssueFormatter(Issue issue, String text) {
        this.issue = issue;
        this.text = text;
    }

    public String getMessage() {
        String res = this.text;
        for (Tag tag : Tag.values()) {
            if (!res.contains(tag.getName())) continue;
            res = res.replace(tag.getName(), this.getValueToReplace(tag));
        }
        return res;
    }

    private String getValueToReplace(Tag tag) {
        switch (tag) {
            case KEY: {
                return this.issue.getKey();
            }
            case COMPONENT: {
                return this.issue.getComponent();
            }
            case MESSAGE: {
                return this.issue.getMessage();
            }
            case SEVERITY: {
                return this.issue.getSeverity().name();
            }
            case RULE: {
                return this.issue.getRule();
            }
            case RULE_URL: {
                return this.issue.getRuleUrl();
            }
            case STATUS: {
                return this.issue.getStatus();
            }
            case CREATION_DATE: {
                return this.issue.getCreationDate().toString();
            }
        }
        throw new IllegalArgumentException("Unexpected tag " + (Object)((Object)tag));
    }

    public static enum Tag {
        KEY("<key>"),
        COMPONENT("<component>"),
        MESSAGE("<message>"),
        SEVERITY("<severity>"),
        RULE("<rule>"),
        RULE_URL("<rule_url>"),
        STATUS("<status>"),
        CREATION_DATE("<creation_date>");

        private final String name;

        private Tag(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

