/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.review;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.common.DiffInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.sonargerrit.review.RevisionAdapter;
import org.jenkinsci.plugins.sonargerrit.util.Localization;

public class GerritRevisionWrapper
implements RevisionAdapter {
    private RevisionApi revision;
    protected Set<String> changedFiles;
    protected boolean dataLoaded;
    private Map<String, Set<Integer>> file2changedLines;

    public GerritRevisionWrapper(RevisionApi revision) {
        this.revision = revision;
        this.dataLoaded = false;
    }

    public void loadData() throws RestApiException {
        this.dataLoaded = true;
        this.changedFiles = this.calculateChangedFiles();
        this.file2changedLines = this.calculateFile2ChangedLines();
    }

    public void sendReview(ReviewInput reviewInput) throws RestApiException {
        this.revision.review(reviewInput);
    }

    @Override
    public Set<String> getChangedFiles() {
        if (!this.dataLoaded) {
            throw new IllegalStateException(Localization.getLocalized("jenkins.plugin.error.gerrit.revision.data.not.loaded"));
        }
        return this.changedFiles;
    }

    @Override
    public Map<String, Set<Integer>> getFileToChangedLines() {
        if (!this.dataLoaded) {
            throw new IllegalStateException(Localization.getLocalized("jenkins.plugin.error.gerrit.revision.data.not.loaded"));
        }
        return this.file2changedLines;
    }

    protected Set<String> calculateChangedFiles() throws RestApiException {
        return this.revision.files().keySet();
    }

    protected Map<String, Set<Integer>> calculateFile2ChangedLines() throws RestApiException {
        HashMap<String, Set<Integer>> file2changedLinesInfo = new HashMap<String, Set<Integer>>();
        Map files = this.revision.files();
        for (String filename : files.keySet()) {
            Set<Integer> changedLinesByFile = this.getChangedLinesByFile(filename);
            file2changedLinesInfo.put(filename, changedLinesByFile);
        }
        return file2changedLinesInfo;
    }

    protected Set<Integer> getChangedLinesByFile(String filename) throws RestApiException {
        DiffInfo diffInfo = this.revision.file(filename).diff();
        return this.getChangedLines(diffInfo);
    }

    @VisibleForTesting
    Set<Integer> getChangedLines(DiffInfo diffInfo) {
        HashSet<Integer> rangeSet = new HashSet<Integer>();
        int processed = 0;
        for (DiffInfo.ContentEntry contentEntry : diffInfo.content) {
            if (contentEntry.ab != null) {
                processed += contentEntry.ab.size();
                continue;
            }
            if (contentEntry.b == null) continue;
            int start = processed + 1;
            int end = processed + contentEntry.b.size();
            for (int i = start; i <= end; ++i) {
                rangeSet.add(i);
            }
            processed = end;
        }
        return rangeSet;
    }
}

