/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.review;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.sonargerrit.config.InspectionConfig;
import org.jenkinsci.plugins.sonargerrit.config.NotificationConfig;
import org.jenkinsci.plugins.sonargerrit.config.ReviewConfig;
import org.jenkinsci.plugins.sonargerrit.config.ScoreConfig;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.IssueAdapter;
import org.jenkinsci.plugins.sonargerrit.review.formatter.CustomIssueFormatter;
import org.jenkinsci.plugins.sonargerrit.review.formatter.CustomReportFormatter;

public class GerritReviewBuilder {
    private Multimap<String, IssueAdapter> finalIssuesToComment;
    private Multimap<String, IssueAdapter> finalIssuesToScore;
    private ReviewConfig reviewConfig;
    private ScoreConfig scoreConfig;
    private NotificationConfig notificationConfig;
    private InspectionConfig inspectionConfig;

    public GerritReviewBuilder(Multimap<String, IssueAdapter> finalIssuesToComment, Multimap<String, IssueAdapter> finalIssuesToScore, ReviewConfig reviewConfig, ScoreConfig scoreConfig, NotificationConfig notificationConfig, InspectionConfig inspectionConfig) {
        this.finalIssuesToComment = finalIssuesToComment;
        this.finalIssuesToScore = finalIssuesToScore;
        this.reviewConfig = reviewConfig;
        this.scoreConfig = scoreConfig;
        this.notificationConfig = notificationConfig;
        this.inspectionConfig = inspectionConfig;
    }

    public ReviewInput buildReview() {
        String reviewMessage = this.getReviewMessage(this.finalIssuesToComment);
        ReviewInput reviewInput = new ReviewInput().message(reviewMessage);
        reviewInput.comments = this.generateComments();
        int score = 0;
        if (this.postScore()) {
            score = this.getReviewMark(this.finalIssuesToScore.size());
            String category = this.scoreConfig.getCategory();
            reviewInput.label(category, score);
        }
        reviewInput.notify = this.getNotificationSettings(this.finalIssuesToComment.size(), score);
        return reviewInput;
    }

    private boolean postScore() {
        return this.scoreConfig != null;
    }

    private String getReviewMessage(Multimap<String, IssueAdapter> finalIssues) {
        return new CustomReportFormatter(finalIssues.values(), this.reviewConfig.getSomeIssuesTitleTemplate(), this.reviewConfig.getNoIssuesTitleTemplate()).getMessage();
    }

    private int getReviewMark(int finalIssuesCount) {
        return finalIssuesCount > 0 ? this.scoreConfig.getIssuesScore() : this.scoreConfig.getNoIssuesScore();
    }

    private NotifyHandling getNotificationSettings(int commentsCount, int score) {
        if (score < 0) {
            return NotifyHandling.valueOf((String)this.notificationConfig.getNegativeScoreNotificationRecipient());
        }
        if (commentsCount > 0) {
            return NotifyHandling.valueOf((String)this.notificationConfig.getCommentedIssuesNotificationRecipient());
        }
        return NotifyHandling.valueOf((String)this.notificationConfig.getNoIssuesNotificationRecipient());
    }

    private Map<String, List<ReviewInput.CommentInput>> generateComments() {
        HashMap<String, List<ReviewInput.CommentInput>> file2comments = new HashMap<String, List<ReviewInput.CommentInput>>();
        for (String file : this.finalIssuesToComment.keySet()) {
            Collection issues = this.finalIssuesToComment.get((Object)file);
            Collection comments = Collections2.transform((Collection)issues, (Function)new IssueToCommentTransformation());
            ArrayList commentList = Lists.newArrayList((Iterable)comments);
            file2comments.put(file, commentList);
        }
        return file2comments;
    }

    protected ReviewInput.CommentInput createComment(@Nullable IssueAdapter input) {
        if (input == null) {
            return null;
        }
        String commentTemplate = this.reviewConfig.getIssueCommentTemplate();
        String message = new CustomIssueFormatter(input, commentTemplate, this.inspectionConfig.getServerURL()).getMessage();
        ReviewInput.CommentInput commentInput = new ReviewInput.CommentInput();
        commentInput.id = input.getKey();
        commentInput.line = input.getLine();
        commentInput.message = message;
        return commentInput;
    }

    private class IssueToCommentTransformation
    implements Function<IssueAdapter, ReviewInput.CommentInput> {
        private IssueToCommentTransformation() {
        }

        @Nullable
        public ReviewInput.CommentInput apply(@Nullable IssueAdapter input) {
            return GerritReviewBuilder.this.createComment(input);
        }
    }
}

