/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.review;

import com.google.common.base.MoreObjects;
import com.google.gerrit.extensions.api.GerritApi;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritManagement;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.urswolfer.gerrit.client.rest.GerritAuthData;
import com.urswolfer.gerrit.client.rest.GerritRestApiFactory;
import com.urswolfer.gerrit.client.rest.http.HttpClientBuilderExtension;
import org.jenkinsci.plugins.sonargerrit.review.ConnectionInfo;
import org.jenkinsci.plugins.sonargerrit.review.GerritConnectionInfo;
import org.jenkinsci.plugins.sonargerrit.util.DataHelper;
import org.jenkinsci.plugins.sonargerrit.util.Localization;

public class GerritConnector {
    private GerritApi gerritApi;
    private ConnectionInfo connectionInfo;

    public GerritConnector(GerritConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public boolean isConnected() {
        return this.gerritApi != null;
    }

    public void connect() {
        String serverName = this.connectionInfo.getServerName();
        IGerritHudsonTriggerConfig gerritConfig = GerritManagement.getConfig((String)serverName);
        DataHelper.checkNotNull(gerritConfig, "jenkins.plugin.error.gerrit.config.empty");
        String gerritFrontEndUrl = gerritConfig.getGerritFrontEndUrl();
        boolean useRestApi = gerritConfig.isUseRestApi();
        this.checkRestApiAllowed(useRestApi);
        String username = this.getUsername(this.connectionInfo.getUsername(), gerritConfig);
        String password = this.getPassword(this.connectionInfo.getPassword(), gerritConfig);
        DataHelper.checkNotEmpty(username, "jenkins.plugin.error.gerrit.user.empty");
        GerritRestApiFactory gerritRestApiFactory = new GerritRestApiFactory();
        GerritAuthData.Basic authData = new GerritAuthData.Basic(gerritFrontEndUrl, username, password, useRestApi);
        this.gerritApi = gerritRestApiFactory.create((GerritAuthData)authData, new HttpClientBuilderExtension[0]);
    }

    public RevisionApi getRevision() throws RestApiException {
        return this.gerritApi.changes().id(this.connectionInfo.getChangeNumber()).revision(this.connectionInfo.getPatchsetNumber());
    }

    private void checkRestApiAllowed(boolean useRestApi) {
        if (!useRestApi) {
            throw new IllegalStateException(Localization.getLocalized("jenkins.plugin.error.gerrit.restapi.off"));
        }
    }

    private String getUsername(String username, IGerritHudsonTriggerConfig gerritConfig) {
        return (String)MoreObjects.firstNonNull((Object)username, (Object)gerritConfig.getGerritHttpUserName());
    }

    private String getPassword(String password, IGerritHudsonTriggerConfig gerritConfig) {
        return (String)MoreObjects.firstNonNull((Object)password, (Object)gerritConfig.getGerritHttpPassword());
    }
}

