/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.inspection.sonarqube;

import com.google.common.collect.Multimap;
import hudson.AbortException;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.sonargerrit.TaskListenerLogger;
import org.jenkinsci.plugins.sonargerrit.config.InspectionConfig;
import org.jenkinsci.plugins.sonargerrit.config.SubJobConfig;
import org.jenkinsci.plugins.sonargerrit.inspection.InspectionReportAdapter;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.IssueAdapter;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.Report;
import org.jenkinsci.plugins.sonargerrit.inspection.sonarqube.InspectionReport;
import org.jenkinsci.plugins.sonargerrit.inspection.sonarqube.SonarReportBuilder;
import org.jenkinsci.plugins.sonargerrit.util.Localization;

public class SonarConnector
implements InspectionReportAdapter {
    private static final Logger LOGGER = Logger.getLogger(SonarConnector.class.getName());
    private TaskListener listener;
    private InspectionReport report;
    private InspectionConfig inspectionConfig;

    public SonarConnector(TaskListener listener, InspectionConfig inspectionConfig) {
        this.inspectionConfig = inspectionConfig;
        this.listener = listener;
    }

    public void readSonarReports(FilePath workspace) throws IOException, InterruptedException {
        ArrayList<ReportInfo> reports = new ArrayList<ReportInfo>();
        for (SubJobConfig subJobConfig : this.inspectionConfig.getAllSubJobConfigs()) {
            Report report = this.readSonarReport(workspace, subJobConfig.getSonarReportPath());
            if (report == null) {
                TaskListenerLogger.logMessage(this.listener, LOGGER, Level.SEVERE, "jenkins.plugin.error.path.no.project.config.available", new Object[0]);
                throw new AbortException(Localization.getLocalized("jenkins.plugin.error.path.no.project.config.available"));
            }
            reports.add(new ReportInfo(subJobConfig, report));
        }
        this.report = new InspectionReport(reports);
    }

    @Override
    public Multimap<String, IssueAdapter> getReportData() {
        return this.report.asMultimap(this.getIssues());
    }

    public Multimap<String, IssueAdapter> getReportData(Iterable<IssueAdapter> issues) {
        return this.report.asMultimap(issues);
    }

    public List<IssueAdapter> getIssues() {
        return this.report.getIssuesList();
    }

    Report getRawReport(SubJobConfig config) {
        return this.report.getRawReport(config);
    }

    private Report readSonarReport(FilePath workspace, String sonarReportPath) throws IOException, InterruptedException {
        FilePath reportPath = workspace.child(sonarReportPath);
        if (!reportPath.exists()) {
            TaskListenerLogger.logMessage(this.listener, LOGGER, Level.SEVERE, "jenkins.plugin.error.sonar.report.not.exists", reportPath);
            return null;
        }
        if (reportPath.isDirectory()) {
            TaskListenerLogger.logMessage(this.listener, LOGGER, Level.SEVERE, "jenkins.plugin.error.sonar.report.path.directory", reportPath);
            return null;
        }
        TaskListenerLogger.logMessage(this.listener, LOGGER, Level.INFO, "jenkins.plugin.inspection.report.loading", reportPath);
        SonarReportBuilder builder = new SonarReportBuilder();
        String reportJson = reportPath.readToString();
        Report report = builder.fromJson(reportJson);
        TaskListenerLogger.logMessage(this.listener, LOGGER, Level.INFO, "jenkins.plugin.inspection.report.loaded", report.getIssues().size());
        return report;
    }

    static class ReportInfo {
        public final SubJobConfig config;
        public final Report report;

        public ReportInfo(SubJobConfig config, Report report) {
            this.config = config;
            this.report = report;
        }
    }
}

