/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.inspection.sonarqube;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.sonargerrit.config.SubJobConfig;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.Issue;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.IssueAdapter;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.Report;
import org.jenkinsci.plugins.sonargerrit.inspection.sonarqube.ComponentPathBuilder;
import org.jenkinsci.plugins.sonargerrit.inspection.sonarqube.SonarConnector;
import org.jenkinsci.plugins.sonargerrit.inspection.sonarqube.SonarQubeIssueAdapter;

public class InspectionReport {
    private List<IssueAdapter> issuesList;
    private List<SonarConnector.ReportInfo> reportInfos;

    public InspectionReport(List<SonarConnector.ReportInfo> issueInfos) {
        this.reportInfos = issueInfos;
        this.issuesList = new ArrayList<IssueAdapter>();
        for (SonarConnector.ReportInfo info : issueInfos) {
            Report report = info.report;
            this.generateIssueAdapterList(info.config, report, report.getIssues());
        }
    }

    private String getFilepath(IssueAdapter i) {
        return i.getFilepath();
    }

    public List<IssueAdapter> getIssuesList() {
        return new ArrayList<IssueAdapter>(this.issuesList);
    }

    public Multimap<String, IssueAdapter> asMultimap(Iterable<IssueAdapter> issues) {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        for (IssueAdapter i : issues) {
            multimap.put((Object)this.getFilepath(i), (Object)i);
        }
        return multimap;
    }

    private void generateIssueAdapterList(SubJobConfig config, Report report, Iterable<Issue> issues) {
        ComponentPathBuilder pathBuilder = new ComponentPathBuilder(report.getComponents());
        for (Issue issue : issues) {
            this.issuesList.add(new SonarQubeIssueAdapter(issue, pathBuilder, config));
        }
    }

    @VisibleForTesting
    Report getRawReport(SubJobConfig config) {
        if (config != null && config.getProjectPath() != null && config.getSonarReportPath() != null) {
            for (SonarConnector.ReportInfo reportInfo : this.reportInfos) {
                SubJobConfig rconfig = reportInfo.config;
                if (!config.getProjectPath().equals(rconfig.getProjectPath()) || !config.getSonarReportPath().equals(rconfig.getSonarReportPath())) continue;
                return reportInfo.report;
            }
        }
        return null;
    }
}

