/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.filter.predicates;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.Set;
import org.jenkinsci.plugins.sonargerrit.inspection.entity.IssueAdapter;

public class ByFilenamesPredicate
implements Predicate<IssueAdapter> {
    private final Set<String> allowedComponents = new HashSet<String>();

    private ByFilenamesPredicate(Set<String> allowedComponents) {
        if (allowedComponents != null) {
            this.allowedComponents.addAll(allowedComponents);
        }
    }

    public boolean apply(IssueAdapter issue) {
        return this.allowedComponents != null && this.allowedComponents.contains(issue.getFilepath());
    }

    public static ByFilenamesPredicate apply(Set<String> allowedComponents) {
        return new ByFilenamesPredicate(allowedComponents);
    }
}

