/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.config;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.sonargerrit.config.SubJobConfig;
import org.jenkinsci.plugins.sonargerrit.util.Localization;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class InspectionConfig
extends AbstractDescribableImpl<InspectionConfig> {
    @Nonnull
    private String serverURL = "http://localhost:9000";
    private SubJobConfig baseConfig;
    @Nonnull
    private Collection<SubJobConfig> subJobConfigs;
    private String type;

    @DataBoundConstructor
    public InspectionConfig() {
        this("http://localhost:9000", null, null, "base");
    }

    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    private InspectionConfig(@Nonnull String serverURL, SubJobConfig baseConfig, List<SubJobConfig> subJobConfigs, String type) {
        this.setServerURL(serverURL);
        this.setBaseConfig(baseConfig);
        this.setSubJobConfigs(subJobConfigs);
        this.setType(type);
    }

    public DescriptorImpl getDescriptor() {
        return new DescriptorImpl();
    }

    @Nonnull
    public String getServerURL() {
        return this.serverURL;
    }

    @DataBoundSetter
    public void setServerURL(@Nonnull String serverURL) {
        this.serverURL = (String)MoreObjects.firstNonNull((Object)Util.fixEmptyAndTrim((String)serverURL), (Object)"http://localhost:9000");
    }

    public SubJobConfig getBaseConfig() {
        return this.baseConfig;
    }

    @DataBoundSetter
    public void setBaseConfig(SubJobConfig baseConfig) {
        this.baseConfig = (SubJobConfig)((Object)MoreObjects.firstNonNull((Object)((Object)baseConfig), (Object)((Object)new SubJobConfig())));
    }

    public Collection<SubJobConfig> getSubJobConfigs() {
        return this.subJobConfigs;
    }

    public Collection<SubJobConfig> getAllSubJobConfigs() {
        return this.isMultiConfigMode() ? this.subJobConfigs : Collections.singletonList(this.baseConfig);
    }

    public boolean isType(String type) {
        return this.type.equalsIgnoreCase(type);
    }

    @DataBoundSetter
    public void setType(String type) {
        if (DescriptorImpl.ALLOWED_TYPES.contains(type)) {
            this.type = type;
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean isMultiConfigMode() {
        return this.isType("multi");
    }

    public boolean isAutoMatch() {
        return !this.isMultiConfigMode() && this.baseConfig.isAutoMatch();
    }

    @DataBoundSetter
    public void setAutoMatch(boolean autoMatch) {
        if (!this.isMultiConfigMode()) {
            this.baseConfig.setAutoMatch(autoMatch);
        }
    }

    @DataBoundSetter
    public void setSubJobConfigs(Collection<SubJobConfig> subJobConfigs) {
        if (subJobConfigs != null && subJobConfigs.size() > 0) {
            this.subJobConfigs = new LinkedList<SubJobConfig>(subJobConfigs);
        } else {
            this.subJobConfigs = new LinkedList<SubJobConfig>();
            this.subJobConfigs.add(new SubJobConfig());
        }
    }

    public boolean isPathCorrectionNeeded() {
        return this.isAutoMatch();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<InspectionConfig> {
        public static final String SONAR_URL = "http://localhost:9000";
        public static final String BASE_TYPE = "base";
        public static final String MULTI_TYPE = "multi";
        public static final String DEFAULT_INSPECTION_CONFIG_TYPE = "base";
        public static final boolean AUTO_MATCH = false;
        private static final Set<String> ALLOWED_TYPES = new HashSet<String>(Arrays.asList("base", "multi"));

        public FormValidation doCheckServerURL(@QueryParameter String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.warning((String)Localization.getLocalized("jenkins.plugin.error.sonar.url.empty"));
            }
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                return FormValidation.warning((String)Localization.getLocalized("jenkins.plugin.error.sonar.url.invalid"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "InspectionConfig";
        }
    }
}

