/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.config;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritManagement;
import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import hudson.Extension;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.sonargerrit.config.AuthenticationConfig;
import org.jenkinsci.plugins.sonargerrit.util.Localization;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GerritAuthenticationConfig
extends AuthenticationConfig {
    public GerritAuthenticationConfig(@Nonnull String username, @Nonnull String password) {
        super(username, password);
    }

    @DataBoundConstructor
    public GerritAuthenticationConfig() {
    }

    @Override
    @DataBoundSetter
    public void setPassword(@Nonnull String password) {
        super.setPassword(password);
    }

    @Override
    @DataBoundSetter
    public void setUsername(@Nonnull String username) {
        super.setUsername(username);
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends AuthenticationConfig.DescriptorImpl {
        @Override
        public FormValidation doTestConnection(@QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="serverName") String serverName) throws IOException, ServletException {
            this.doCheckUsername(username);
            this.doCheckPassword(password);
            IGerritHudsonTriggerConfig gerritConfig = GerritManagement.getConfig((String)serverName);
            if (gerritConfig == null) {
                return FormValidation.error((String)Localization.getLocalized("jenkins.plugin.error.gerrit.config.empty"));
            }
            if (!gerritConfig.isUseRestApi()) {
                return FormValidation.error((String)Localization.getLocalized("jenkins.plugin.error.gerrit.restapi.off"));
            }
            GerritServer server = PluginImpl.getServer_((String)serverName);
            if (server == null) {
                return FormValidation.error((String)Localization.getLocalized("jenkins.plugin.error.gerrit.server.empty"));
            }
            return server.getDescriptor().doTestRestConnection(gerritConfig.getGerritFrontEndUrl(), username, password);
        }

        @Override
        public List<String> getServerNames() {
            return PluginImpl.getServerNames_();
        }

        @Override
        public String getDisplayName() {
            return "GerritAuthenticationConfig";
        }
    }
}

