/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.workflow;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import com.google.common.collect.ImmutableSet;
import groovy.json.JsonOutput;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.CredentialsObtainer;
import jenkins.plugins.slack.Messages;
import jenkins.plugins.slack.SlackNotifier;
import jenkins.plugins.slack.SlackService;
import jenkins.plugins.slack.StandardSlackService;
import jenkins.plugins.slack.workflow.SlackResponse;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.groovy.JsonSlurper;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.json.JSONException;
import org.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SlackSendStep
extends Step {
    private static final Logger logger = Logger.getLogger(SlackSendStep.class.getName());
    private String message;
    private String color;
    private String token;
    private String tokenCredentialId;
    private boolean botUser;
    private String channel;
    private String baseUrl;
    private String teamDomain;
    private boolean failOnError;
    private Object attachments;
    private boolean replyBroadcast;

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    public String getColor() {
        return this.color;
    }

    @DataBoundSetter
    public void setColor(String color) {
        this.color = Util.fixEmpty((String)color);
    }

    public String getToken() {
        return this.token;
    }

    @DataBoundSetter
    public void setToken(String token) {
        this.token = Util.fixEmpty((String)token);
    }

    public String getTokenCredentialId() {
        return this.tokenCredentialId;
    }

    @DataBoundSetter
    public void setTokenCredentialId(String tokenCredentialId) {
        this.tokenCredentialId = Util.fixEmpty((String)tokenCredentialId);
    }

    public boolean getBotUser() {
        return this.botUser;
    }

    @DataBoundSetter
    public void setBotUser(boolean botUser) {
        this.botUser = botUser;
    }

    public String getChannel() {
        return this.channel;
    }

    @DataBoundSetter
    public void setChannel(String channel) {
        this.channel = Util.fixEmpty((String)channel);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = Util.fixEmpty((String)baseUrl);
        if (this.baseUrl != null && !this.baseUrl.isEmpty() && !this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
    }

    public String getTeamDomain() {
        return this.teamDomain;
    }

    @DataBoundSetter
    public void setTeamDomain(String teamDomain) {
        this.teamDomain = Util.fixEmpty((String)teamDomain);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @DataBoundSetter
    public void setAttachments(Object attachments) {
        this.attachments = attachments;
    }

    public Object getAttachments() {
        return this.attachments;
    }

    @DataBoundSetter
    public void setMessage(String message) {
        this.message = message;
    }

    public boolean getReplyBroadcast() {
        return this.replyBroadcast;
    }

    @DataBoundSetter
    public void setReplyBroadcast(boolean replyBroadcast) {
        this.replyBroadcast = replyBroadcast;
    }

    @DataBoundConstructor
    public SlackSendStep() {
    }

    public StepExecution start(StepContext context) {
        return new SlackSendStepExecution(this, context);
    }

    public static class SlackSendStepExecution
    extends SynchronousNonBlockingStepExecution<SlackResponse> {
        private static final long serialVersionUID = 1L;
        private final transient SlackSendStep step;

        SlackSendStepExecution(SlackSendStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected SlackResponse run() throws Exception {
            boolean publishSuccess;
            String populatedToken;
            Jenkins jenkins = Jenkins.get();
            Item item = this.getItemForCredentials();
            SlackNotifier.DescriptorImpl slackDesc = (SlackNotifier.DescriptorImpl)jenkins.getDescriptorByType(SlackNotifier.DescriptorImpl.class);
            String baseUrl = this.step.baseUrl != null ? this.step.baseUrl : slackDesc.getBaseUrl();
            String teamDomain = this.step.teamDomain != null ? this.step.teamDomain : slackDesc.getTeamDomain();
            String tokenCredentialId = this.step.tokenCredentialId != null ? this.step.tokenCredentialId : slackDesc.getTokenCredentialId();
            String token = this.step.token;
            boolean botUser = this.step.botUser || slackDesc.isBotUser();
            String channel = this.step.channel != null ? this.step.channel : slackDesc.getRoom();
            String color = this.step.color != null ? this.step.color : "";
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            Objects.requireNonNull(listener, "Listener is mandatory here");
            listener.getLogger().println(Messages.SlackSendStepValues(this.defaultIfEmpty(baseUrl), this.defaultIfEmpty(teamDomain), channel, this.defaultIfEmpty(color), botUser, this.defaultIfEmpty(tokenCredentialId)));
            try {
                populatedToken = CredentialsObtainer.getTokenToUse(tokenCredentialId, item, token);
            }
            catch (IllegalArgumentException e) {
                listener.error(Messages.NotificationFailedWithException(e));
                return null;
            }
            SlackService slackService = this.getSlackService(baseUrl, teamDomain, botUser, channel, this.step.replyBroadcast, populatedToken);
            if (this.step.attachments != null) {
                JSONArray jsonArray = this.getAttachmentsAsJSONArray();
                for (Object object : jsonArray) {
                    net.sf.json.JSONObject jsonNode;
                    if (!(object instanceof net.sf.json.JSONObject) || (jsonNode = (net.sf.json.JSONObject)object).has("fallback")) continue;
                    jsonNode.put("fallback", (Object)this.step.message);
                }
                publishSuccess = slackService.publish(this.step.message, jsonArray, color);
            } else if (this.step.message != null) {
                publishSuccess = slackService.publish(this.step.message, color);
            } else {
                listener.error(Messages.NotificationFailedWithException(new IllegalArgumentException("No message or attachments provided")));
                return null;
            }
            SlackResponse response = null;
            if (publishSuccess) {
                String responseString = slackService.getResponseString();
                if (responseString == null) return new SlackResponse();
                try {
                    JSONObject result = new JSONObject(responseString);
                    return new SlackResponse(result);
                }
                catch (JSONException ex) {
                    listener.error(Messages.FailedToParseSlackResponse(responseString));
                    if (!this.step.failOnError) return response;
                    throw ex;
                }
            }
            if (this.step.failOnError) {
                throw new AbortException(Messages.NotificationFailed());
            }
            listener.error(Messages.NotificationFailed());
            return response;
        }

        JSONArray getAttachmentsAsJSONArray() throws Exception {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            String jsonString = this.step.attachments instanceof String ? (String)this.step.attachments : JsonOutput.toJson((Object)this.step.attachments);
            JsonSlurper jsonSlurper = new JsonSlurper();
            JSON json = null;
            try {
                json = jsonSlurper.parseText(jsonString);
            }
            catch (net.sf.json.JSONException e) {
                listener.error(Messages.NotificationFailedWithException((Object)e));
                return null;
            }
            if (!(json instanceof JSONArray)) {
                listener.error(Messages.NotificationFailedWithException(new IllegalArgumentException("Attachments must be JSONArray")));
                return null;
            }
            return (JSONArray)json;
        }

        private Item getItemForCredentials() {
            Object item = null;
            try {
                item = (Item)this.getContext().get(Project.class);
                if (item == null) {
                    Run run = (Run)this.getContext().get(Run.class);
                    item = run != null ? run.getParent() : null;
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception obtaining item for credentials lookup. Only global credentials will be available", e);
            }
            return item;
        }

        private String defaultIfEmpty(String value) {
            return Util.fixEmpty((String)value) != null ? value : Messages.SlackSendStepValuesEmptyMessage();
        }

        SlackService getSlackService(String baseUrl, String team, boolean botUser, String channel, boolean replyBroadcast, String populatedToken) {
            return new StandardSlackService(baseUrl, team, botUser, channel, replyBroadcast, populatedToken);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "slackSend";
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.SlackSendStepDisplayName();
        }

        public ListBoxModel doFillTokenCredentialIdItems(@AncestorInPath Item item) {
            Jenkins jenkins = Jenkins.get();
            if (item == null && !jenkins.hasPermission(Jenkins.ADMINISTER) || item != null && !item.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{new HostnameRequirement("*.slack.com")}));
        }

        public FormValidation doCheckToken(@QueryParameter String value) {
            return FormValidation.warning((String)"Exposing your Integration Token is a security risk. Please use the Integration Token Credential ID");
        }
    }
}

