/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.webhook;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import java.util.UUID;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.plugins.slack.webhook.CommandRouter;
import jenkins.plugins.slack.webhook.GetProjectLogCommand;
import jenkins.plugins.slack.webhook.GlobalConfig;
import jenkins.plugins.slack.webhook.ListProjectsCommand;
import jenkins.plugins.slack.webhook.ScheduleJobCommand;
import jenkins.plugins.slack.webhook.exception.CommandRouterException;
import jenkins.plugins.slack.webhook.exception.RouteNotFoundException;
import jenkins.plugins.slack.webhook.model.JsonResponse;
import jenkins.plugins.slack.webhook.model.SlackPostData;
import jenkins.plugins.slack.webhook.model.SlackTextMessage;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class WebhookEndpoint
implements UnprotectedRootAction {
    private GlobalConfig globalConfig;
    private static final Logger LOGGER = Logger.getLogger(WebhookEndpoint.class.getName());

    private GlobalConfig getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = (GlobalConfig)((Object)GlobalConfiguration.all().get(GlobalConfig.class));
        }
        return this.globalConfig;
    }

    public String getUrlName() {
        String url = this.getGlobalConfig().getSlackOutgoingWebhookURL();
        if (url == null || url.equals("")) {
            return UUID.randomUUID().toString().replaceAll("-", "");
        }
        return url;
    }

    @RequirePOST
    public HttpResponse doIndex(StaplerRequest req) {
        if (this.getGlobalConfig().getSlackOutgoingWebhookToken() == null || this.getGlobalConfig().getSlackOutgoingWebhookToken().equals("")) {
            return new JsonResponse(new SlackTextMessage("Slack token not set"), 200);
        }
        SlackPostData data = new SlackPostData();
        req.bindParameters((Object)data);
        if (!this.getGlobalConfig().getSlackOutgoingWebhookToken().equals(data.getToken())) {
            return new JsonResponse(new SlackTextMessage("Invalid Slack token"), 200);
        }
        String commandText = data.getText();
        if (commandText == null || commandText.isEmpty()) {
            return new JsonResponse(new SlackTextMessage("Invalid command, text field required"), 200);
        }
        String triggerWord = data.getTrigger_word();
        if (triggerWord != null && !triggerWord.isEmpty()) {
            if (!commandText.startsWith(triggerWord)) {
                return new JsonResponse(new SlackTextMessage("Invalid command, invalid trigger_word"), 200);
            }
            commandText = commandText.trim().replaceFirst(triggerWord, "").trim();
        }
        CommandRouter<SlackTextMessage> router = new CommandRouter<SlackTextMessage>();
        try {
            router.addRoute("^list projects", triggerWord + " list projects", "Return a list of buildable projects", new ListProjectsCommand(data)).addRoute("^run ([\\p{L}\\p{N}\\p{ASCII}\\W]+)", triggerWord + " run <project_name>", "Schedule a run for <project_name>", new ScheduleJobCommand(data)).addRoute("^get ([\\p{L}\\p{N}\\p{ASCII}\\W]+) #([0-9]+) log", triggerWord + " get <project-name> #<build_number> log", "Return a truncated log for build #<build_number> of <project_name>", new GetProjectLogCommand(data));
            SlackTextMessage msg = (SlackTextMessage)router.route(commandText);
            return new JsonResponse(msg, 200);
        }
        catch (RouteNotFoundException ex) {
            LOGGER.warning(ex.getMessage());
            String command = ex.getRouteCommand();
            StringBuilder builder = new StringBuilder("*Help:*\n");
            if (command.split("\\s+").length > 1) {
                builder.append("`").append(command).append("` _is an unknown command, try one of the following:_\n\n");
            } else {
                builder.append("\n");
            }
            for (CommandRouter.Route route : router.getRoutes()) {
                builder.append("`").append(route.command).append("`\n```").append(route.commandDescription).append("```").append("\n\n");
            }
            return new JsonResponse(new SlackTextMessage(builder.toString()), 200);
        }
        catch (CommandRouterException ex) {
            LOGGER.warning(ex.getMessage());
            return new JsonResponse(new SlackTextMessage(ex.getMessage()), 200);
        }
        catch (Exception ex) {
            LOGGER.warning(ex.getMessage());
            return new JsonResponse(new SlackTextMessage("An error occured: " + ex.getMessage()), 200);
        }
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }
}

