/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import hudson.ProxyConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.CredentialsObtainer;
import jenkins.plugins.slack.SlackService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class StandardSlackService
implements SlackService {
    private static final Logger logger = Logger.getLogger(StandardSlackService.class.getName());
    private String host = "slack.com";
    private String baseUrl;
    private String teamDomain;
    private boolean botUser;
    private String[] roomIds;
    private boolean replyBroadcast;
    private String responseString;
    private String populatedToken;

    @Deprecated
    public StandardSlackService(String baseUrl, String teamDomain, String authTokenCredentialId, boolean botUser, String roomId) {
        this(baseUrl, teamDomain, null, authTokenCredentialId, botUser, roomId, false);
    }

    @Deprecated
    public StandardSlackService(String baseUrl, String teamDomain, String token, String authTokenCredentialId, boolean botUser, String roomId) {
        this(baseUrl, teamDomain, token, authTokenCredentialId, botUser, roomId, false);
    }

    @Deprecated
    public StandardSlackService(String baseUrl, String teamDomain, String token, String authTokenCredentialId, boolean botUser, String roomId, boolean replyBroadcast) {
        this(baseUrl, teamDomain, botUser, roomId, replyBroadcast);
        this.populatedToken = this.getTokenToUse(authTokenCredentialId, token);
        if (this.populatedToken == null) {
            throw new IllegalArgumentException("No slack token found, setup a secret text credential and configure it to be used");
        }
    }

    public StandardSlackService(String baseUrl, String teamDomain, boolean botUser, String roomId, boolean replyBroadcast, String populatedToken) {
        this(baseUrl, teamDomain, botUser, roomId, replyBroadcast);
        if (populatedToken == null) {
            throw new IllegalArgumentException("No slack token found, setup a secret text credential and configure it to be used");
        }
        this.populatedToken = populatedToken;
    }

    private StandardSlackService(String baseUrl, String teamDomain, boolean botUser, String roomId, boolean replyBroadcast) {
        this.baseUrl = baseUrl;
        if (this.baseUrl != null && !this.baseUrl.isEmpty() && !this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
        this.teamDomain = teamDomain;
        this.botUser = botUser;
        if (roomId == null) {
            throw new IllegalArgumentException("Project Channel or Slack User ID must be specified.");
        }
        this.roomIds = roomId.split("[,; ]+");
        this.replyBroadcast = replyBroadcast;
    }

    @Override
    public String getResponseString() {
        return this.responseString;
    }

    @Override
    public boolean publish(String message) {
        return this.publish(message, "warning");
    }

    @Override
    public boolean publish(String message, String color) {
        JSONObject field = new JSONObject();
        field.put("short", (Object)false);
        field.put("value", (Object)message);
        JSONArray fields = new JSONArray();
        fields.add((Object)field);
        JSONObject attachment = new JSONObject();
        attachment.put("fallback", (Object)message);
        attachment.put("color", (Object)color);
        attachment.put("fields", (Object)fields);
        JSONArray mrkdwn = new JSONArray();
        mrkdwn.add((Object)"pretext");
        mrkdwn.add((Object)"text");
        mrkdwn.add((Object)"fields");
        attachment.put("mrkdwn_in", (Object)mrkdwn);
        JSONArray attachments = new JSONArray();
        attachments.add((Object)attachment);
        return this.publish(null, attachments, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean publish(String message, JSONArray attachments, String color) {
        boolean result = true;
        for (String roomId : this.roomIds) {
            HttpPost post;
            String url;
            String threadTs = "";
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            String[] splitThread = roomId.split("[:]+");
            if (splitThread.length > 1) {
                roomId = splitThread[0];
                threadTs = splitThread[1];
            }
            if (!this.botUser || !StringUtils.isEmpty((String)this.baseUrl)) {
                url = "https://" + this.teamDomain + "." + this.host + "/services/hooks/jenkins-ci?token=" + this.populatedToken;
                if (!StringUtils.isEmpty((String)this.baseUrl)) {
                    url = this.baseUrl + this.populatedToken;
                }
                post = new HttpPost(url);
                JSONObject json = new JSONObject();
                json.put("channel", (Object)roomId);
                if (StringUtils.isNotEmpty((String)message)) {
                    json.put("text", (Object)message);
                }
                json.put("attachments", (Object)attachments);
                json.put("link_names", (Object)"1");
                nvps.add(new BasicNameValuePair("payload", json.toString()));
            } else {
                url = "https://slack.com/api/chat.postMessage?token=" + this.populatedToken + "&channel=" + roomId.replace("#", "") + "&link_names=1&as_user=true";
                if (threadTs.length() > 1) {
                    url = url + "&thread_ts=" + threadTs;
                }
                if (this.replyBroadcast) {
                    url = url + "&reply_broadcast=true";
                }
                try {
                    url = url + "&attachments=" + URLEncoder.encode(attachments.toString(), "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.log(Level.ALL, "Error while encoding attachments: " + e.getMessage());
                }
                post = new HttpPost(url);
            }
            logger.fine("Posting: to " + roomId + " on " + this.teamDomain + " using " + url + ": " + attachments.toString() + " " + color);
            CloseableHttpClient client = this.getHttpClient();
            try {
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
                CloseableHttpResponse response = client.execute((HttpUriRequest)post);
                int responseCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (this.botUser && entity != null) {
                    this.responseString = EntityUtils.toString((HttpEntity)entity);
                }
                if (responseCode != 200) {
                    logger.log(Level.WARNING, "Slack post may have failed. Response: " + this.responseString);
                    logger.log(Level.WARNING, "Response Code: " + responseCode);
                    result = false;
                    continue;
                }
                logger.fine("Posting succeeded");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error posting to Slack", e);
                result = false;
            }
            finally {
                post.releaseConnection();
            }
        }
        return result;
    }

    private String getTokenToUse(String authTokenCredentialId, String token) {
        StringCredentials credentials;
        if (!StringUtils.isEmpty((String)authTokenCredentialId) && (credentials = CredentialsObtainer.lookupCredentials(authTokenCredentialId)) != null) {
            logger.fine("Using Integration Token Credential ID.");
            return credentials.getSecret().getPlainText();
        }
        logger.fine("Using Integration Token.");
        return token;
    }

    protected CloseableHttpClient getHttpClient() {
        ProxyConfiguration proxy;
        HttpClientBuilder clientBuilder = HttpClients.custom();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null && (proxy = jenkins.proxy) != null) {
            HttpHost proxyHost = new HttpHost(proxy.name, proxy.port);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
            clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            String username = proxy.getUserName();
            String password = proxy.getPassword();
            if (username != null && !"".equals(username.trim())) {
                logger.info("Using proxy authentication (user=" + username + ")");
                credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        return clientBuilder.build();
    }

    void setHost(String host) {
        this.host = host;
    }
}

