/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.ActiveNotifier;
import jenkins.plugins.slack.CommitInfoChoice;
import jenkins.plugins.slack.CredentialsObtainer;
import jenkins.plugins.slack.JenkinsTokenExpander;
import jenkins.plugins.slack.SlackService;
import jenkins.plugins.slack.StandardSlackService;
import jenkins.plugins.slack.config.GlobalCredentialMigrator;
import jenkins.plugins.slack.logging.BuildAwareLogger;
import jenkins.plugins.slack.logging.BuildKey;
import jenkins.plugins.slack.logging.SlackNotificationsLogger;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SlackNotifier
extends Notifier {
    private static final Logger logger = Logger.getLogger(SlackNotifier.class.getName());
    private String baseUrl;
    private String teamDomain;
    private String authToken;
    private String tokenCredentialId;
    private boolean botUser;
    private String room;
    private String sendAs;
    private boolean startNotification;
    private boolean notifySuccess;
    private boolean notifyAborted;
    private boolean notifyNotBuilt;
    private boolean notifyUnstable;
    private boolean notifyRegression;
    private boolean notifyFailure;
    private boolean notifyBackToNormal;
    private boolean notifyRepeatedFailure;
    private boolean includeTestSummary;
    private boolean includeFailedTests;
    private CommitInfoChoice commitInfoChoice;
    private boolean includeCustomMessage;
    private String customMessage;
    private String customMessageSuccess;
    private String customMessageAborted;
    private String customMessageNotBuilt;
    private String customMessageUnstable;
    private String customMessageFailure;
    private transient String authTokenCredentialId;

    public String getAuthTokenCredentialId() {
        return this.tokenCredentialId;
    }

    private Object readResolve() {
        if (this.authTokenCredentialId != null) {
            this.tokenCredentialId = this.authTokenCredentialId;
        }
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getTeamDomain() {
        return this.teamDomain;
    }

    @DataBoundSetter
    public void setTeamDomain(String teamDomain) {
        this.teamDomain = teamDomain;
    }

    public String getRoom() {
        return this.room;
    }

    @DataBoundSetter
    public void setRoom(String room) {
        this.room = room;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    @DataBoundSetter
    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getTokenCredentialId() {
        return this.tokenCredentialId;
    }

    @DataBoundSetter
    public void setTokenCredentialId(String tokenCredentialId) {
        this.tokenCredentialId = tokenCredentialId;
    }

    public boolean getBotUser() {
        return this.botUser;
    }

    @DataBoundSetter
    public void setBotUser(boolean botUser) {
        this.botUser = botUser;
    }

    public String getSendAs() {
        return this.sendAs;
    }

    @DataBoundSetter
    public void setSendAs(String sendAs) {
        this.sendAs = sendAs;
    }

    public boolean getStartNotification() {
        return this.startNotification;
    }

    public boolean getNotifySuccess() {
        return this.notifySuccess;
    }

    public CommitInfoChoice getCommitInfoChoice() {
        return this.commitInfoChoice;
    }

    public boolean getNotifyAborted() {
        return this.notifyAborted;
    }

    public boolean getNotifyFailure() {
        return this.notifyFailure;
    }

    public boolean getNotifyNotBuilt() {
        return this.notifyNotBuilt;
    }

    public boolean getNotifyUnstable() {
        return this.notifyUnstable;
    }

    public boolean getNotifyRegression() {
        return this.notifyRegression;
    }

    public boolean getNotifyBackToNormal() {
        return this.notifyBackToNormal;
    }

    public boolean getIncludeTestSummary() {
        return this.includeTestSummary;
    }

    public boolean getIncludeFailedTests() {
        return this.includeFailedTests;
    }

    public boolean getNotifyRepeatedFailure() {
        return this.notifyRepeatedFailure;
    }

    public boolean getIncludeCustomMessage() {
        return this.includeCustomMessage;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public String getCustomMessageSuccess() {
        return this.customMessageSuccess;
    }

    public String getCustomMessageAborted() {
        return this.customMessageAborted;
    }

    public String getCustomMessageNotBuilt() {
        return this.customMessageNotBuilt;
    }

    public String getCustomMessageUnstable() {
        return this.customMessageUnstable;
    }

    public String getCustomMessageFailure() {
        return this.customMessageFailure;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @DataBoundSetter
    public void setStartNotification(boolean startNotification) {
        this.startNotification = startNotification;
    }

    @DataBoundSetter
    public void setNotifySuccess(boolean notifySuccess) {
        this.notifySuccess = notifySuccess;
    }

    @DataBoundSetter
    public void setCommitInfoChoice(CommitInfoChoice commitInfoChoice) {
        this.commitInfoChoice = commitInfoChoice;
    }

    @DataBoundSetter
    public void setNotifyAborted(boolean notifyAborted) {
        this.notifyAborted = notifyAborted;
    }

    @DataBoundSetter
    public void setNotifyFailure(boolean notifyFailure) {
        this.notifyFailure = notifyFailure;
    }

    @DataBoundSetter
    public void setNotifyNotBuilt(boolean notifyNotBuilt) {
        this.notifyNotBuilt = notifyNotBuilt;
    }

    @DataBoundSetter
    public void setNotifyUnstable(boolean notifyUnstable) {
        this.notifyUnstable = notifyUnstable;
    }

    @DataBoundSetter
    public void setNotifyRegression(boolean notifyRegression) {
        this.notifyRegression = notifyRegression;
    }

    @DataBoundSetter
    public void setNotifyBackToNormal(boolean notifyBackToNormal) {
        this.notifyBackToNormal = notifyBackToNormal;
    }

    @DataBoundSetter
    public void setIncludeTestSummary(boolean includeTestSummary) {
        this.includeTestSummary = includeTestSummary;
    }

    @DataBoundSetter
    public void setIncludeFailedTests(boolean includeFailedTests) {
        this.includeFailedTests = includeFailedTests;
    }

    @DataBoundSetter
    public void setNotifyRepeatedFailure(boolean notifyRepeatedFailure) {
        this.notifyRepeatedFailure = notifyRepeatedFailure;
    }

    @DataBoundSetter
    public void setIncludeCustomMessage(boolean includeCustomMessage) {
        this.includeCustomMessage = includeCustomMessage;
    }

    @DataBoundSetter
    public void setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
    }

    @DataBoundSetter
    public void setCustomMessageSuccess(String customMessageSuccess) {
        this.customMessageSuccess = customMessageSuccess;
    }

    @DataBoundSetter
    public void setCustomMessageAborted(String customMessageAborted) {
        this.customMessageAborted = customMessageAborted;
    }

    @DataBoundSetter
    public void setCustomMessageNotBuilt(String customMessageNotBuilt) {
        this.customMessageNotBuilt = customMessageNotBuilt;
    }

    @DataBoundSetter
    public void setCustomMessageUnstable(String customMessageUnstable) {
        this.customMessageUnstable = customMessageUnstable;
    }

    @DataBoundSetter
    public void setCustomMessageFailure(String customMessageFailure) {
        this.customMessageFailure = customMessageFailure;
    }

    @DataBoundConstructor
    public SlackNotifier(CommitInfoChoice commitInfoChoice) {
        this.commitInfoChoice = commitInfoChoice;
    }

    @Deprecated
    public SlackNotifier(String baseUrl, String teamDomain, String authToken, boolean botUser, String room, String tokenCredentialId, String sendAs, boolean startNotification, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyRegression, boolean notifyBackToNormal, boolean notifyRepeatedFailure, boolean includeTestSummary, boolean includeFailedTests, CommitInfoChoice commitInfoChoice, boolean includeCustomMessage, String customMessage) {
        this(baseUrl, teamDomain, authToken, botUser, room, tokenCredentialId, sendAs, startNotification, notifyAborted, notifyFailure, notifyNotBuilt, notifySuccess, notifyUnstable, notifyRegression, notifyBackToNormal, notifyRepeatedFailure, includeTestSummary, includeFailedTests, commitInfoChoice, includeCustomMessage, customMessage, null, null, null, null, null);
    }

    public SlackNotifier(String baseUrl, String teamDomain, String authToken, boolean botUser, String room, String tokenCredentialId, String sendAs, boolean startNotification, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyRegression, boolean notifyBackToNormal, boolean notifyRepeatedFailure, boolean includeTestSummary, boolean includeFailedTests, CommitInfoChoice commitInfoChoice, boolean includeCustomMessage, String customMessage, String customMessageSuccess, String customMessageAborted, String customMessageNotBuilt, String customMessageUnstable, String customMessageFailure) {
        this.baseUrl = baseUrl;
        if (this.baseUrl != null && !this.baseUrl.isEmpty() && !this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
        this.teamDomain = teamDomain;
        this.authToken = authToken;
        this.tokenCredentialId = StringUtils.trim((String)tokenCredentialId);
        this.botUser = botUser;
        this.room = room;
        this.sendAs = sendAs;
        this.startNotification = startNotification;
        this.notifyAborted = notifyAborted;
        this.notifyFailure = notifyFailure;
        this.notifyNotBuilt = notifyNotBuilt;
        this.notifySuccess = notifySuccess;
        this.notifyUnstable = notifyUnstable;
        this.notifyRegression = notifyRegression;
        this.notifyBackToNormal = notifyBackToNormal;
        this.notifyRepeatedFailure = notifyRepeatedFailure;
        this.includeTestSummary = includeTestSummary;
        this.includeFailedTests = includeFailedTests;
        this.commitInfoChoice = commitInfoChoice;
        this.includeCustomMessage = includeCustomMessage;
        if (includeCustomMessage) {
            this.customMessage = customMessage;
            this.customMessageSuccess = customMessageSuccess;
            this.customMessageAborted = customMessageAborted;
            this.customMessageNotBuilt = customMessageNotBuilt;
            this.customMessageUnstable = customMessageUnstable;
            this.customMessageFailure = customMessageFailure;
        } else {
            this.customMessage = null;
        }
    }

    public boolean isAnyCustomMessagePopulated() {
        return Stream.of(this.customMessage, this.customMessageSuccess, this.customMessageAborted, this.customMessageNotBuilt, this.customMessageUnstable, this.customMessageFailure).anyMatch(StringUtils::isNotEmpty);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public SlackService newSlackService(AbstractBuild abstractBuild, BuildListener listener) {
        EnvVars env;
        DescriptorImpl descriptor = this.getDescriptor();
        String teamDomain = Util.fixEmpty((String)this.teamDomain) != null ? this.teamDomain : descriptor.getTeamDomain();
        String baseUrl = Util.fixEmpty((String)this.baseUrl) != null ? this.baseUrl : descriptor.getBaseUrl();
        String authToken = Util.fixEmpty((String)this.authToken);
        boolean botUser = this.botUser || descriptor.isBotUser();
        String authTokenCredentialId = Util.fixEmpty((String)this.tokenCredentialId) != null ? this.tokenCredentialId : descriptor.getTokenCredentialId();
        String room = Util.fixEmpty((String)this.room) != null ? this.room : descriptor.getRoom();
        try {
            env = abstractBuild.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            listener.getLogger().println("Error retrieving environment vars: " + e.getMessage());
            env = new EnvVars();
        }
        baseUrl = env.expand(baseUrl);
        teamDomain = env.expand(teamDomain);
        authToken = env.expand(authToken);
        authTokenCredentialId = env.expand(authTokenCredentialId);
        room = env.expand(room);
        String populatedToken = CredentialsObtainer.getTokenToUse(authTokenCredentialId, (Item)abstractBuild.getParent(), authToken);
        return new StandardSlackService(baseUrl, teamDomain, botUser, room, false, populatedToken);
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        String buildKey = BuildKey.format(build);
        BuildAwareLogger log = SlackNotifier.createLogger(listener);
        log.debug(buildKey, "Performing complete notifications", new Object[0]);
        JenkinsTokenExpander tokenExpander = new JenkinsTokenExpander((TaskListener)listener);
        try {
            new ActiveNotifier(this, this.slackFactory(listener), log, tokenExpander).completed(build);
            if (this.notifyRegression) {
                log.debug(buildKey, "Performing finalize notifications", new Object[0]);
                new ActiveNotifier(this, this.slackFactory(listener), log, tokenExpander).finalized(build);
            }
        }
        catch (Exception e) {
            log.info(buildKey, "Exception attempting Slack notification: " + e.getMessage(), new Object[0]);
        }
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        String buildKey = BuildKey.format(build);
        BuildAwareLogger log = SlackNotifier.createLogger(listener);
        try {
            if (this.startNotification) {
                log.debug(buildKey, "Performing start notifications", new Object[0]);
                new ActiveNotifier(this, this.slackFactory(listener), log, new JenkinsTokenExpander((TaskListener)listener)).started(build);
            }
        }
        catch (Exception e) {
            log.info(buildKey, "Exception attempting Slack notification: " + e.getMessage(), new Object[0]);
        }
        return super.prebuild(build, listener);
    }

    private Function<AbstractBuild<?, ?>, SlackService> slackFactory(BuildListener listener) {
        return b -> this.newSlackService((AbstractBuild)b, listener);
    }

    private static BuildAwareLogger createLogger(BuildListener listener) {
        return new SlackNotificationsLogger(logger, listener.getLogger());
    }

    @Extension
    @Symbol(value={"slackNotifier"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final String PLUGIN_DISPLAY_NAME = "Slack Notifications";
        private String baseUrl;
        private String teamDomain;
        private String token;
        private String tokenCredentialId;
        private boolean botUser;
        private String room;
        private String sendAs;

        public DescriptorImpl() {
            this.load();
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        @DataBoundSetter
        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getTeamDomain() {
            return this.teamDomain;
        }

        @DataBoundSetter
        public void setTeamDomain(String teamDomain) {
            this.teamDomain = teamDomain;
        }

        @Deprecated
        public String getToken() {
            return this.token;
        }

        @Deprecated
        @DataBoundSetter
        public void setToken(String token) {
            this.token = token;
        }

        public String getTokenCredentialId() {
            return this.tokenCredentialId;
        }

        @DataBoundSetter
        public void setTokenCredentialId(String tokenCredentialId) {
            this.tokenCredentialId = tokenCredentialId;
        }

        public boolean isBotUser() {
            return this.botUser;
        }

        @Deprecated
        public boolean getBotUser() {
            return this.botUser;
        }

        @DataBoundSetter
        public void setBotUser(boolean botUser) {
            this.botUser = botUser;
        }

        public String getRoom() {
            return this.room;
        }

        @DataBoundSetter
        public void setRoom(String room) {
            this.room = room;
        }

        public String getSendAs() {
            return this.sendAs;
        }

        @DataBoundSetter
        public void setSendAs(String sendAs) {
            this.sendAs = sendAs;
        }

        public ListBoxModel doFillCommitInfoChoiceItems() {
            ListBoxModel model = new ListBoxModel();
            for (CommitInfoChoice choice : CommitInfoChoice.values()) {
                model.add(choice.getDisplayName(), choice.name());
            }
            return model;
        }

        public ListBoxModel doFillTokenCredentialIdItems(@AncestorInPath Item context) {
            Jenkins jenkins = Jenkins.get();
            if (context == null && !jenkins.hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{new HostnameRequirement("*.slack.com")}));
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        @Deprecated
        SlackService getSlackService(String baseUrl, String teamDomain, String authTokenCredentialId, boolean botUser, String roomId) {
            return this.getSlackService(baseUrl, teamDomain, authTokenCredentialId, botUser, roomId, null);
        }

        SlackService getSlackService(String baseUrl, String teamDomain, String authTokenCredentialId, boolean botUser, String roomId, Item item) {
            String populatedToken = CredentialsObtainer.getTokenToUse(authTokenCredentialId, item, null);
            if (populatedToken != null) {
                return new StandardSlackService(baseUrl, teamDomain, botUser, roomId, false, populatedToken);
            }
            throw new NoSuchElementException("Could not obtain credentials with credential id: " + authTokenCredentialId);
        }

        @Nonnull
        public String getDisplayName() {
            return PLUGIN_DISPLAY_NAME;
        }

        public FormValidation doTestConnection(@QueryParameter(value="baseUrl") String baseUrl, @QueryParameter(value="teamDomain") String teamDomain, @QueryParameter(value="tokenCredentialId") String tokenCredentialId, @QueryParameter(value="botUser") boolean botUser, @QueryParameter(value="room") String room, @AncestorInPath Project project) {
            try {
                String targetUrl = baseUrl;
                if (targetUrl != null && !targetUrl.isEmpty() && !targetUrl.endsWith("/")) {
                    targetUrl = targetUrl + "/";
                }
                if (StringUtils.isEmpty((String)targetUrl)) {
                    targetUrl = this.baseUrl;
                }
                String targetDomain = Util.fixEmpty((String)teamDomain) != null ? teamDomain : this.teamDomain;
                boolean targetBotUser = botUser || this.botUser;
                String targetTokenCredentialId = Util.fixEmpty((String)tokenCredentialId) != null ? tokenCredentialId : this.tokenCredentialId;
                String targetRoom = Util.fixEmpty((String)room) != null ? room : this.room;
                SlackService testSlackService = this.getSlackService(targetUrl, targetDomain, targetTokenCredentialId, targetBotUser, targetRoom, (Item)project);
                String message = "Slack/Jenkins plugin: you're all set on " + DisplayURLProvider.get().getRoot();
                boolean success = testSlackService.publish(message, "good");
                return success ? FormValidation.ok((String)"Success") : FormValidation.error((String)"Failure");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Slack config form validation error", e);
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        private Object readResolve() {
            if (Util.fixEmpty((String)this.token) != null) {
                this.tokenCredentialId = new GlobalCredentialMigrator().migrate(this.token).getId();
                this.token = null;
                this.save();
            }
            return this;
        }
    }
}

