/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class CredentialsObtainer {
    public static StringCredentials lookupCredentials(String credentialId) {
        List credentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        return CredentialsObtainer.getCredentialWithId(credentialId, credentials);
    }

    public static StringCredentials lookupCredentials(String credentialId, Item item) {
        List credentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList());
        return CredentialsObtainer.getCredentialWithId(credentialId, credentials);
    }

    public static String getTokenToUse(String credentialId, Item item, String token) {
        StringCredentials credentials;
        String response = StringUtils.isEmpty((String)credentialId) ? token : ((credentials = CredentialsObtainer.lookupCredentials(StringUtils.trim((String)credentialId), item)) != null ? credentials.getSecret().getPlainText() : token);
        if (StringUtils.isEmpty((String)response)) {
            throw new IllegalArgumentException("the token with the provided ID could not be found and no token was specified");
        }
        return response;
    }

    private static StringCredentials getCredentialWithId(String credentialId, List<StringCredentials> credentials) {
        CredentialsMatcher matcher = CredentialsMatchers.withId((String)credentialId);
        return (StringCredentials)CredentialsMatchers.firstOrNull(credentials, (CredentialsMatcher)matcher);
    }
}

