/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public class SkytapBuildWrapper
extends BuildWrapper {
    private final String userId;
    private final Secret authKey;

    @DataBoundConstructor
    public SkytapBuildWrapper(String userId, Secret authKey) {
        this.userId = userId;
        this.authKey = authKey;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAuthKey() {
        return Secret.toString((Secret)this.authKey);
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.put("userId", this.userId);
        env.put("authKey", Secret.toString((Secret)this.authKey));
        return new BuildWrapper.Environment(){};
    }

    public void makeBuildVariables(AbstractBuild build, Map<String, String> variables) {
        variables.put("userId", this.userId);
        variables.put("authKey", Secret.toString((Secret)this.authKey));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Skytap Cloud Authentication Credentials";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

