/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class MergeTemplateIntoConfigurationStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String templateID;
    private final String templateFile;
    private final String configFile;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @XStreamOmitField
    private String runtimeTemplateID;
    @XStreamOmitField
    private String authCredentials;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(MergeTemplateIntoConfigurationStep.class, "Merge Template into Environment");

    @DataBoundConstructor
    public MergeTemplateIntoConfigurationStep(String configurationID, String configurationFile, String templateID, String templateFile, String configFile) {
        super("Merge Template into Configuration");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
        this.templateID = templateID;
        this.templateFile = templateFile;
        this.configFile = configFile;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        String expConfigFile;
        String expConfigurationFile;
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Merge Template into Environment Step");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expTemplateFile = SkytapUtils.expandEnvVars(build, this.templateFile);
        if (!expTemplateFile.equals("")) {
            expTemplateFile = SkytapUtils.convertFileNameToFullPath(build, expTemplateFile);
        }
        if (!(expConfigurationFile = SkytapUtils.expandEnvVars(build, this.configurationFile)).equals("")) {
            expConfigurationFile = SkytapUtils.convertFileNameToFullPath(build, expConfigurationFile);
        }
        if (!(expConfigFile = SkytapUtils.expandEnvVars(build, this.configFile)).equals("")) {
            expConfigFile = SkytapUtils.convertFileNameToFullPath(build, expConfigFile);
        }
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(build, this.configurationID, expConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error obtaining runtime environment id: " + e.getMessage());
        }
        try {
            this.runtimeTemplateID = SkytapUtils.getRuntimeId(build, this.templateID, expTemplateFile);
        }
        catch (FileNotFoundException ex) {
            JenkinsLogger.error("Error obtaining runtime template id: " + ex.getMessage());
            return false;
        }
        JenkinsLogger.log("Template ID: " + this.runtimeTemplateID);
        JenkinsLogger.log("Template File: " + expTemplateFile);
        JenkinsLogger.log("Environment ID: " + this.runtimeConfigurationID);
        JenkinsLogger.log("Environment File: " + expConfigurationFile);
        String requestUrl = this.buildMergeRequestURL(this.runtimeTemplateID, this.runtimeConfigurationID);
        HttpPut hp = SkytapUtils.buildHttpPutRequest(requestUrl, this.authCredentials);
        String httpRespBody = "";
        try {
            httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Exception: " + e.getMessage());
            return false;
        }
        try {
            SkytapUtils.checkResponseForErrors(httpRespBody);
        }
        catch (SkytapException ex) {
            JenkinsLogger.error("Request returned an error: " + ex.getError());
            JenkinsLogger.error("Failing build step.");
            return false;
        }
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(httpRespBody);
        JsonObject jo = je.getAsJsonObject();
        if (!expConfigFile.equals("")) {
            expConfigFile = SkytapUtils.convertFileNameToFullPath(build, expConfigFile);
            FilePath fp = new FilePath(build.getWorkspace(), expConfigFile);
            try {
                fp.write(httpRespBody, null);
            }
            catch (IOException e) {
                JenkinsLogger.error("Error: " + e.getMessage());
                JenkinsLogger.error("Skytap Plugin failed to save environment to file: " + expConfigFile);
                return false;
            }
            catch (InterruptedException e) {
                JenkinsLogger.error("Error: " + e.getMessage());
                return false;
            }
        }
        JenkinsLogger.log("Template " + this.runtimeTemplateID + " was successfully merged to environment " + this.runtimeConfigurationID);
        return true;
    }

    private String buildMergeRequestURL(String tempId, String confId) {
        JenkinsLogger.log("Building request url ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com");
        sb.append("/configurations/");
        sb.append(confId);
        sb.append("?template_id=");
        sb.append(tempId);
        JenkinsLogger.log("Request URL: " + sb.toString());
        return sb.toString();
    }

    private Boolean preFlightSanityChecks() {
        if (!this.templateID.equals("") && !this.templateFile.equals("")) {
            JenkinsLogger.error("Values were provided for both template id and file. Please provide just one or the other.");
            return false;
        }
        if (!this.templateID.equals("") && !this.templateFile.equals("")) {
            JenkinsLogger.error("No value was provided for template ID or file. Please provide either a valid Skytap template ID, or a valid template file.");
            return false;
        }
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            return false;
        }
        if (this.configFile.equals("")) {
            JenkinsLogger.log("No optional value was provided for a new environment data save file. Continuing...");
            return true;
        }
        return true;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getTemplateID() {
        return this.templateID;
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public String getConfigFile() {
        return this.configFile;
    }
}

