/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.FileNotFoundException;
import org.apache.http.client.methods.HttpDelete;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeleteContainerStep
extends SkytapBuilder.SkytapAction {
    private final String containerID;
    private final String containerFile;
    private static final int NUMBER_OF_RETRIES = 18;
    private static final int RETRY_INTERVAL_SECONDS = 10;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String authCredentials;
    @XStreamOmitField
    private String runtimeContainerID;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(DeleteContainerStep.class, "Delete Container");

    @DataBoundConstructor
    public DeleteContainerStep(String containerID, String containerFile) {
        super("Delete Container");
        this.containerID = containerID;
        this.containerFile = containerFile;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Delete Container");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expContainerFile = SkytapUtils.expandEnvVars(build, this.containerFile);
        if (!expContainerFile.equals("")) {
            expContainerFile = SkytapUtils.convertFileNameToFullPath(build, expContainerFile);
        }
        try {
            this.runtimeContainerID = SkytapUtils.getRuntimeId(build, this.containerID, expContainerFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error retrieving container id: " + e.getMessage());
            return false;
        }
        JenkinsLogger.log("Sending delete request for container id " + this.runtimeContainerID);
        if (!this.attemptDeleteContainer(this.runtimeContainerID).booleanValue()) {
            JenkinsLogger.error("Container ID: " + this.runtimeContainerID + " could not be deleted. Failing build step.");
            return false;
        }
        JenkinsLogger.defaultLogMessage("Container " + this.runtimeContainerID + " was successfully deleted.");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    private Boolean attemptDeleteContainer(String confId) {
        String requestURL = this.buildRequestURL(confId);
        HttpDelete hd = SkytapUtils.buildHttpDeleteRequest(requestURL, this.authCredentials);
        String httpRespBody = "";
        Boolean containerDeletedSuccessfully = false;
        int pollAttempts = 0;
        while (!containerDeletedSuccessfully.booleanValue()) {
            if (pollAttempts >= 18) break;
            int sleepTime = 10;
            JenkinsLogger.log("Sleeping for " + sleepTime + " seconds.");
            try {
                Thread.sleep(sleepTime * 1000);
            }
            catch (InterruptedException e1) {
                JenkinsLogger.error(e1.getMessage());
            }
            httpRespBody = SkytapUtils.executeHttpDeleteRequest(hd);
            if (httpRespBody.contains("error")) {
                JenkinsLogger.error("An error occurred while attempting to delete " + confId);
                ++pollAttempts;
                continue;
            }
            containerDeletedSuccessfully = true;
        }
        return containerDeletedSuccessfully;
    }

    private String buildRequestURL(String containerId) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("/v2/containers/");
        sb.append(containerId);
        return sb.toString();
    }

    private Boolean preFlightSanityChecks() {
        if (!this.containerID.equals("") && !this.containerFile.equals("")) {
            JenkinsLogger.error("Values were provided for both container ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.containerFile.equals("") && this.containerID.equals("")) {
            JenkinsLogger.error("No value was provided for container ID or file. Please provide either a valid Skytap container ID, or a valid container file.");
            return false;
        }
        return true;
    }

    public String getContainerID() {
        return this.containerID;
    }

    public String getContainerFile() {
        return this.containerFile;
    }
}

