/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class GetContainerMetaDataStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String vmID;
    private final String vmName;
    private final String containerName;
    private final String containerDataFile;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @XStreamOmitField
    private String runtimeVMID;
    @XStreamOmitField
    private String authCredentials;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(GetContainerMetaDataStep.class, "Get Container Metadata");

    @DataBoundConstructor
    public GetContainerMetaDataStep(String configurationID, String configurationFile, String vmID, String vmName, String containerName, String containerDataFile) {
        super("Get Container Metadata Step");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
        this.vmID = vmID;
        this.vmName = vmName;
        this.containerName = containerName;
        this.containerDataFile = containerDataFile;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Get Container Metadata");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        if (!expConfigFile.equals("")) {
            expConfigFile = SkytapUtils.convertFileNameToFullPath(build, expConfigFile);
        }
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(build, this.configurationID, expConfigFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error retrieving environment id: " + e.getMessage());
            return false;
        }
        if (!this.vmName.isEmpty()) {
            try {
                this.runtimeVMID = SkytapUtils.getVMIDFromName(this.runtimeConfigurationID, this.vmName, this.authCredentials);
            }
            catch (SkytapException e) {
                JenkinsLogger.error(e.getMessage());
                return false;
            }
        } else {
            this.runtimeVMID = this.vmID;
        }
        String containerId = "";
        try {
            containerId = SkytapUtils.getVMContainerIdFromName(this.runtimeConfigurationID, this.runtimeVMID, this.containerName, this.authCredentials);
        }
        catch (SkytapException e) {
            JenkinsLogger.error(e.getMessage());
            return false;
        }
        String getContainerMetadataURL = this.buildGetContainerDataURL(containerId);
        HttpGet hget = SkytapUtils.buildHttpGetRequest(getContainerMetadataURL, this.authCredentials);
        String containerMetadataResponse = "";
        try {
            containerMetadataResponse = SkytapUtils.executeHttpRequest((HttpRequestBase)hget);
        }
        catch (SkytapException e) {
            JenkinsLogger.error(e.getMessage());
            return false;
        }
        try {
            SkytapUtils.checkResponseForErrors(containerMetadataResponse);
        }
        catch (SkytapException ex) {
            JenkinsLogger.error("Request returned an error: " + ex.getMessage());
            JenkinsLogger.error("Failing build step.");
            return false;
        }
        JenkinsLogger.log(containerMetadataResponse);
        String expContainerDataFile = SkytapUtils.expandEnvVars(build, this.containerDataFile);
        expContainerDataFile = SkytapUtils.convertFileNameToFullPath(build, expContainerDataFile);
        JenkinsLogger.log("Outputting container metadata to file: " + expContainerDataFile);
        try {
            FilePath fp = new FilePath(build.getWorkspace(), expContainerDataFile);
            fp.write(containerMetadataResponse, null);
        }
        catch (IOException e) {
            JenkinsLogger.error("Error: " + e.getMessage());
            JenkinsLogger.error("Skytap Plugin failed to save container metadata to file: " + expContainerDataFile);
            return false;
        }
        catch (InterruptedException e) {
            JenkinsLogger.error("Error: " + e.getMessage());
            return false;
        }
        return true;
    }

    private String buildGetContainerDataURL(String containerId) {
        JenkinsLogger.log("Building request url ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("v2/containers/");
        sb.append(containerId);
        sb.append(".json");
        return sb.toString();
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            return false;
        }
        if (this.vmID.isEmpty() && this.vmName.isEmpty()) {
            JenkinsLogger.error("No value was provided for VM ID or name. Please provide either a valid Skytap VM ID or name.");
            return false;
        }
        if (!this.vmID.equals("") && !this.vmName.equals("")) {
            JenkinsLogger.error("Values were provided for both VM ID and name. Please provide just one or the other.");
            return false;
        }
        if (this.containerName.equals("") || this.containerDataFile.equals("")) {
            JenkinsLogger.error("One or more arguments were omitted. Please provide all of the following: container name and container data save file.");
            return false;
        }
        return true;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getVmID() {
        return this.vmID;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getContainerDataFile() {
        return this.containerDataFile;
    }
}

