/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BasicHttpEntity;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConnectToVPNTunnelStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String configurationNetworkName;
    private final String vpnID;
    private static final int NUMBER_OF_RETRIES = 18;
    private static final int RETRY_INTERVAL_SECONDS = 10;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String authCredentials;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(ConnectToVPNTunnelStep.class, "Connect to VPN Tunnel");

    @DataBoundConstructor
    public ConnectToVPNTunnelStep(String configurationID, String configurationFile, String configurationNetworkName, String vpnID) {
        super("Connect to VPN Tunnel");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
        this.configurationNetworkName = configurationNetworkName;
        this.vpnID = vpnID;
    }

    private String buildIsConnectedCheckURL(String confId, String netId, String vpnId) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(confId);
        sb.append("/networks/");
        sb.append(netId);
        sb.append("/vpns/");
        sb.append(vpnId);
        String checkUrl = sb.toString();
        return checkUrl;
    }

    private Boolean checkIsAlreadyConnected(String confId, String netId, String vpnId) throws SkytapException {
        JenkinsLogger.log("Verifying if network " + netId + " is already connected to VPN " + vpnId);
        Boolean isConnected = false;
        String reqURL = this.buildIsConnectedCheckURL(confId, netId, vpnId);
        HttpGet hg = SkytapUtils.buildHttpGetRequest(reqURL, this.authCredentials);
        String httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
        try {
            SkytapUtils.checkResponseForErrors(httpRespBody);
        }
        catch (SkytapException e) {
            if (e.getMessage().contains("Environment not attached to VPN")) {
                return isConnected;
            }
            throw e;
        }
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(httpRespBody);
        JsonObject jo = je.getAsJsonObject();
        isConnected = jo.get("connected").getAsBoolean();
        return isConnected;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Connecting to VPN Tunnel");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigurationFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        if (!expConfigurationFile.equals("")) {
            expConfigurationFile = SkytapUtils.convertFileNameToFullPath(build, expConfigurationFile);
        }
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(build, this.configurationID, expConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error obtaining runtime id: " + e.getMessage());
            return false;
        }
        JenkinsLogger.log("Getting the ID for network: " + this.configurationNetworkName);
        String runtimeNetworkID = "";
        try {
            runtimeNetworkID = SkytapUtils.getNetworkIdFromName(this.runtimeConfigurationID, this.configurationNetworkName, this.authCredentials);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error(e1.getError());
            return false;
        }
        if (runtimeNetworkID.equals("")) {
            JenkinsLogger.error("Failed to obtain network ID.");
            return false;
        }
        JenkinsLogger.log("Environment ID: " + this.runtimeConfigurationID);
        JenkinsLogger.log("Environment File: " + expConfigurationFile);
        JenkinsLogger.log("Network ID: " + runtimeNetworkID);
        JenkinsLogger.log("Network Name: " + this.configurationNetworkName);
        JenkinsLogger.log("VPN ID: " + this.vpnID);
        Boolean alreadyConnected = false;
        try {
            alreadyConnected = this.checkIsAlreadyConnected(this.runtimeConfigurationID, runtimeNetworkID, this.vpnID);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error("Skytap Error: " + e1.getMessage());
            return false;
        }
        if (alreadyConnected.booleanValue()) {
            JenkinsLogger.log("Network is already connected to VPN: " + this.vpnID + ". Passing build step.");
            return true;
        }
        JenkinsLogger.log("Network is not currently connected to VPN: " + this.vpnID);
        JenkinsLogger.log("Attaching VPN to Environment ...");
        if (!this.executeVPNAttach(this.runtimeConfigurationID, runtimeNetworkID, this.vpnID).booleanValue()) {
            JenkinsLogger.error("VPN attach has failed. Failing build step.");
            return false;
        }
        JenkinsLogger.log("VPN with ID " + this.vpnID + " successfully attached to Network with ID " + runtimeNetworkID + ".");
        JenkinsLogger.log("Connecting VPN to Environment ...");
        if (!this.executeVPNConnect(this.runtimeConfigurationID, runtimeNetworkID, this.vpnID).booleanValue()) {
            JenkinsLogger.error("VPN connect has failed. Failing build step.");
            return false;
        }
        JenkinsLogger.defaultLogMessage("VPN with ID " + this.vpnID + " successfully connected to Network with ID " + runtimeNetworkID + ".");
        int sleepTime = 10;
        JenkinsLogger.log("Pausing for " + sleepTime + " seconds.");
        try {
            Thread.sleep(sleepTime * 1000);
        }
        catch (InterruptedException e1) {
            JenkinsLogger.error(e1.getMessage());
        }
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return true;
    }

    private Boolean executeVPNConnect(String confId, String netId, String vpnId) {
        String connectResponse = "";
        Boolean vpnConnectedSuccessfully = false;
        int pollAttempts = 0;
        while (!vpnConnectedSuccessfully.booleanValue()) {
            if (pollAttempts >= 18) break;
            connectResponse = this.connectVPNToConfiguration(confId, netId, vpnId);
            JenkinsLogger.log("Connect Response: " + connectResponse);
            if (connectResponse.equals("") || connectResponse == null) {
                JenkinsLogger.error("Response was null or empty.");
            }
            try {
                SkytapUtils.checkResponseForErrors(connectResponse);
                vpnConnectedSuccessfully = true;
            }
            catch (SkytapException e) {
                JenkinsLogger.error("Skytap Error: " + e.getError());
                int sleepTime = 10;
                JenkinsLogger.log("Sleeping for " + sleepTime + " seconds.");
                try {
                    Thread.sleep(sleepTime * 1000);
                }
                catch (InterruptedException e1) {
                    JenkinsLogger.error(e1.getMessage());
                }
            }
            ++pollAttempts;
        }
        return vpnConnectedSuccessfully;
    }

    private Boolean executeVPNAttach(String confId, String netId, String vpnId) {
        Boolean vpnAttachedSuccessfully = false;
        int pollAttempts = 0;
        String attachResponse = "";
        while (!vpnAttachedSuccessfully.booleanValue()) {
            if (pollAttempts >= 18) break;
            attachResponse = this.attachVPNToConfiguration(confId, netId, vpnId);
            JenkinsLogger.log("Attach Response: " + attachResponse);
            if (attachResponse.equals("") || attachResponse == null) {
                JenkinsLogger.error("Response was null or empty.");
            } else {
                try {
                    SkytapUtils.checkResponseForErrors(attachResponse);
                    vpnAttachedSuccessfully = true;
                }
                catch (SkytapException e) {
                    JenkinsLogger.error("Skytap Error: " + e.getError());
                    int sleepTime = 10;
                    JenkinsLogger.log("Sleeping for " + sleepTime + " seconds.");
                    try {
                        Thread.sleep(sleepTime * 1000);
                    }
                    catch (InterruptedException e1) {
                        JenkinsLogger.error(e1.getMessage());
                    }
                }
            }
            ++pollAttempts;
        }
        return vpnAttachedSuccessfully;
    }

    private String connectVPNToConfiguration(String confId, String networkId, String vpnId) {
        String reqUrl = this.buildConnectRequestURL(confId, networkId, vpnId);
        HttpPut hp = SkytapUtils.buildHttpPutRequest(reqUrl, this.authCredentials);
        BasicHttpEntity he = new BasicHttpEntity();
        he.setContentEncoding("gzip");
        he.setContentType("application/json");
        String jsonString = "{\"connected\" :true}";
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes("UTF-8"));
            Integer len = jsonString.getBytes("UTF-8").length;
            long llen = len.longValue();
            he.setContent((InputStream)stream);
            he.setContentLength(llen);
        }
        catch (UnsupportedEncodingException e) {
            JenkinsLogger.error("Error encoding json string for connected attribute: " + e.getMessage());
        }
        hp.setEntity((HttpEntity)he);
        String response = "";
        try {
            response = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Exception: " + e.getMessage());
        }
        return response;
    }

    private String buildConnectRequestURL(String confId, String networkId, String vpnId) {
        String req = this.buildRequestURL(confId, networkId);
        StringBuilder sb = new StringBuilder(req);
        sb.append("/");
        sb.append(vpnId);
        sb.append("/");
        JenkinsLogger.log(sb.toString());
        return sb.toString();
    }

    private String buildRequestURL(String confId, String networkId) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(confId);
        sb.append("/networks/");
        sb.append(networkId);
        sb.append("/vpns");
        String requestUrl = sb.toString();
        return requestUrl;
    }

    private String attachVPNToConfiguration(String confId, String networkId, String vpnId) {
        String requestUrl = this.buildRequestURL(confId, networkId);
        HttpPost hp = SkytapUtils.buildHttpPostRequest(requestUrl, this.authCredentials);
        BasicHttpEntity he = new BasicHttpEntity();
        he.setContentEncoding("gzip");
        he.setContentType("application/json");
        String jsonString = "{\"id\":\"" + vpnId + "\"}";
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(jsonString.getBytes("UTF-8"));
            Integer len = jsonString.getBytes("UTF-8").length;
            long llen = len.longValue();
            he.setContent((InputStream)stream);
            he.setContentLength(llen);
        }
        catch (UnsupportedEncodingException e) {
            JenkinsLogger.error("Error encoding json string for vpn id: " + e.getMessage());
        }
        hp.setEntity((HttpEntity)he);
        JenkinsLogger.log("HTTP POST request: " + hp.toString());
        String httpRespBody = "";
        try {
            httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Exception: " + e.getMessage());
        }
        return httpRespBody;
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            return false;
        }
        if (this.vpnID.equals("")) {
            JenkinsLogger.error("No value was provided for the VPN ID. Please provide a valid Skytap VPN ID.");
            return false;
        }
        if (this.configurationNetworkName.equals("")) {
            JenkinsLogger.error("No value was provided for the network name. Please provide a valid Skytap Network name.");
            return false;
        }
        return true;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getConfigurationNetworkName() {
        return this.configurationNetworkName;
    }

    public String getVpnID() {
        return this.vpnID;
    }
}

