/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ListPublishedURLForConfigurationStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String urlName;
    private final String urlFile;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @XStreamOmitField
    private String runtimeTemplateID;
    @XStreamOmitField
    private String authCredentials;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(ListPublishedURLForConfigurationStep.class, "List Sharing Portal for Environment");

    @DataBoundConstructor
    public ListPublishedURLForConfigurationStep(String configurationID, String configurationFile, String urlName, String urlFile) {
        super("List Published URL For Configuration");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
        this.urlFile = urlFile;
        this.urlName = urlName;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("List Sharing Portal for Environment Step");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigurationFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        String expUrlFile = SkytapUtils.expandEnvVars(build, this.urlFile);
        expUrlFile = SkytapUtils.convertFileNameToFullPath(build, expUrlFile);
        if (!expConfigurationFile.equals("")) {
            expConfigurationFile = SkytapUtils.convertFileNameToFullPath(build, expConfigurationFile);
        }
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(this.configurationID, expConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error obtaining runtime environment id: " + e.getMessage());
        }
        JenkinsLogger.log("Environment ID: " + this.runtimeConfigurationID);
        JenkinsLogger.log("Environment File: " + expConfigurationFile);
        JenkinsLogger.log("URL Name: " + this.urlName);
        JenkinsLogger.log("URL Save Filename: " + expUrlFile);
        String requestUrl = this.buildListRequestURL(this.runtimeConfigurationID);
        HttpGet hg = SkytapUtils.buildHttpGetRequest(requestUrl, this.authCredentials);
        String httpRespBody = "";
        try {
            httpRespBody = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
            SkytapUtils.checkResponseForErrors(httpRespBody);
        }
        catch (SkytapException e) {
            JenkinsLogger.error(e.getMessage());
            return false;
        }
        JsonParser parser = new JsonParser();
        JsonElement je = parser.parse(httpRespBody);
        JsonObject jo = je.getAsJsonObject();
        JsonArray ja = jo.getAsJsonArray("publish_sets");
        String publishedUrl = "";
        try {
            publishedUrl = this.getPublishedUrl(ja, this.urlName);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error(e1.getMessage());
            return false;
        }
        if (publishedUrl.equals("")) {
            JenkinsLogger.error("URL Name: " + this.urlName + " could not be found in publish_sets for environment " + this.runtimeConfigurationID);
            JenkinsLogger.error("Failing build step.");
            return false;
        }
        JenkinsLogger.log("Outputting url to file: " + expUrlFile);
        try {
            File file = new File(expUrlFile);
            BufferedWriter output = null;
            output = new BufferedWriter(new FileWriter(file));
            output.write(publishedUrl);
            ((Writer)output).close();
        }
        catch (IOException e) {
            JenkinsLogger.error("Skytap Plugin failed to save url to file: " + expUrlFile);
            return false;
        }
        return true;
    }

    private String getPublishedUrl(JsonArray ja, String name) throws SkytapException {
        JenkinsLogger.log("Scanning publish_sets ...");
        for (JsonElement publishSetElement : ja) {
            String pubSetName = publishSetElement.getAsJsonObject().get("name").getAsString();
            JenkinsLogger.log("Sharing Portal Name: " + pubSetName);
            if (!pubSetName.equals(name)) continue;
            JenkinsLogger.log("Sharing Portal Name matched: " + pubSetName);
            String publishSetType = publishSetElement.getAsJsonObject().get("publish_set_type").getAsString();
            if (publishSetType.equals("multiple_url")) {
                throw new SkytapException("URLs for individual VMs are not supported.");
            }
            if (!publishSetType.equals("single_url")) continue;
            String desktopsUrl = publishSetElement.getAsJsonObject().get("desktops_url").getAsString();
            return desktopsUrl;
        }
        JenkinsLogger.log("No publish_sets matched user provided name: " + name);
        return "";
    }

    private String buildListRequestURL(String confId) {
        JenkinsLogger.log("Building request url ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com");
        sb.append("/configurations/");
        sb.append(confId);
        JenkinsLogger.log("Request URL: " + sb.toString());
        return sb.toString();
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getUrlName() {
        return this.urlName;
    }

    public String getUrlFile() {
        return this.urlFile;
    }

    private Boolean preFlightSanityChecks() {
        if (this.urlFile.equals("")) {
            JenkinsLogger.error("No value was provided for the URL save filename. Please provide a filename.");
            return false;
        }
        if (this.urlName.equals("")) {
            JenkinsLogger.error("No value was provided for URL name. Please provide a valid url name.");
            return false;
        }
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            return false;
        }
        return true;
    }
}

