/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.skytap;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Extension;
import hudson.model.AbstractBuild;
import java.io.FileNotFoundException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.jenkinsci.plugins.skytap.JenkinsLogger;
import org.jenkinsci.plugins.skytap.SkytapBuilder;
import org.jenkinsci.plugins.skytap.SkytapException;
import org.jenkinsci.plugins.skytap.SkytapGlobalVariables;
import org.jenkinsci.plugins.skytap.SkytapUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ChangeConfigurationStateStep
extends SkytapBuilder.SkytapAction {
    private final String configurationID;
    private final String configurationFile;
    private final String targetRunState;
    private final Boolean haltOnFailedShutdown;
    private static final int NUMBER_OF_RETRIES = 5;
    private static final int BASE_RETRY_INTERVAL_SECONDS = 20;
    @XStreamOmitField
    private SkytapGlobalVariables globalVars;
    @XStreamOmitField
    private String authCredentials;
    @XStreamOmitField
    private String runtimeConfigurationID;
    @Extension
    public static final SkytapBuilder.SkytapActionDescriptor D = new SkytapBuilder.SkytapActionDescriptor(ChangeConfigurationStateStep.class, "Change Environment State");

    @DataBoundConstructor
    public ChangeConfigurationStateStep(String configurationID, String configurationFile, String targetRunState, Boolean haltOnFailedShutdown) {
        super("Change Configuration State");
        this.configurationID = configurationID;
        this.configurationFile = configurationFile;
        this.targetRunState = targetRunState;
        this.haltOnFailedShutdown = haltOnFailedShutdown;
    }

    @Override
    public Boolean executeStep(AbstractBuild build, SkytapGlobalVariables globalVars) {
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        JenkinsLogger.defaultLogMessage("Changing Environment State");
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        if (!this.preFlightSanityChecks().booleanValue()) {
            return false;
        }
        this.globalVars = globalVars;
        this.authCredentials = SkytapUtils.getAuthCredentials(build);
        String expConfigurationFile = SkytapUtils.expandEnvVars(build, this.configurationFile);
        if (!expConfigurationFile.equals("")) {
            expConfigurationFile = SkytapUtils.convertFileNameToFullPath(build, expConfigurationFile);
        }
        try {
            this.runtimeConfigurationID = SkytapUtils.getRuntimeId(this.configurationID, expConfigurationFile);
        }
        catch (FileNotFoundException e) {
            JenkinsLogger.error("Error obtaining runtime id: " + e.getMessage());
            return false;
        }
        String currentRunState = "";
        try {
            currentRunState = this.getCurrentConfigurationRunstate(this.runtimeConfigurationID);
        }
        catch (SkytapException e2) {
            JenkinsLogger.error("Error obtaining current runstate: " + e2.getMessage());
            return false;
        }
        JenkinsLogger.log("Environment ID: " + this.runtimeConfigurationID);
        JenkinsLogger.log("Environment File: " + expConfigurationFile);
        JenkinsLogger.log("Target runstate: " + this.targetRunState);
        JenkinsLogger.log("Current runstate: " + currentRunState);
        if (this.targetRunState.equals(currentRunState)) {
            JenkinsLogger.defaultLogMessage("Info: Current runstate appears to be equal to target runstate.");
            JenkinsLogger.defaultLogMessage("----------------------------------------");
        } else if (!this.isConfigStateTransitionValid(currentRunState, this.targetRunState).booleanValue()) {
            JenkinsLogger.defaultLogMessage("Skytap will not permit a transition between " + currentRunState + " and " + this.targetRunState);
            JenkinsLogger.defaultLogMessage("Aborting build step.");
            JenkinsLogger.defaultLogMessage("----------------------------------------");
            return false;
        }
        this.sendStateChangeRequest(this.runtimeConfigurationID, this.targetRunState);
        int i = 1;
        while (true) {
            if (i > 5) break;
            try {
                int sleepTime = 20 * i;
                JenkinsLogger.log("Sleeping for " + sleepTime + " seconds.");
                Thread.sleep(sleepTime * 1000);
            }
            catch (InterruptedException e1) {
                JenkinsLogger.error(e1.getMessage());
            }
            JenkinsLogger.log("Checking environment runstate..");
            try {
                currentRunState = this.getCurrentConfigurationRunstate(this.runtimeConfigurationID);
            }
            catch (SkytapException e) {
                JenkinsLogger.error("Error retrieving current runstate: " + e.getMessage());
            }
            JenkinsLogger.log("Current runstate=" + currentRunState);
            if (currentRunState.equals(this.targetRunState)) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    JenkinsLogger.error("Error: " + e.getMessage());
                }
                JenkinsLogger.defaultLogMessage("Runstate transitioned successfully.");
                JenkinsLogger.defaultLogMessage("----------------------------------------");
                return true;
            }
            if (!currentRunState.equals("busy")) {
                this.sendStateChangeRequest(this.runtimeConfigurationID, this.targetRunState);
            }
            ++i;
        }
        if (this.haltOnFailedShutdown.booleanValue() && this.targetRunState.equals("stopped")) {
            JenkinsLogger.defaultLogMessage("Shutdown has failed. Attempting to halt VM.");
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                JenkinsLogger.error("Error: " + e.getMessage());
            }
            this.sendStateChangeRequest(this.runtimeConfigurationID, "halted");
            JenkinsLogger.log("Sleeping for 60 seconds.");
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                JenkinsLogger.error("Error: " + e.getMessage());
            }
            JenkinsLogger.log("Checking if VM is powered down ...");
            String currentState = "";
            try {
                currentState = this.getCurrentConfigurationRunstate(this.runtimeConfigurationID);
            }
            catch (SkytapException e) {
                JenkinsLogger.error("Error getting runstate: " + e.getMessage());
            }
            JenkinsLogger.log("Current state: " + currentState);
            if (currentState.equals("stopped")) {
                JenkinsLogger.defaultLogMessage("VM powered down successfully.");
                JenkinsLogger.defaultLogMessage("----------------------------------------");
                return true;
            }
            JenkinsLogger.error("Failed to power down VM");
            return false;
        }
        JenkinsLogger.defaultLogMessage("----------------------------------------");
        return false;
    }

    private Boolean preFlightSanityChecks() {
        if (!this.configurationID.equals("") && !this.configurationFile.equals("")) {
            JenkinsLogger.error("Values were provided for both environment ID and file. Please provide just one or the other.");
            JenkinsLogger.defaultLogMessage("----------------------------------------");
            return false;
        }
        if (this.configurationFile.equals("") && this.configurationID.equals("")) {
            JenkinsLogger.error("No value was provided for environment ID or file. Please provide either a valid Skytap environment ID, or a valid environment file.");
            JenkinsLogger.defaultLogMessage("----------------------------------------");
            return false;
        }
        return true;
    }

    private void sendStateChangeRequest(String confId, String tgtState) {
        JenkinsLogger.log("Sending state change request for environment id " + confId + ". Target runstate is " + tgtState);
        String requestURL = this.buildRequestURL(confId, tgtState);
        HttpPut hp = SkytapUtils.buildHttpPutRequest(requestURL, this.authCredentials);
        String httpRespBody = "";
        try {
            SkytapUtils.executeHttpRequest((HttpRequestBase)hp);
        }
        catch (SkytapException e1) {
            JenkinsLogger.error("Skytap Error: " + e1.getMessage());
        }
        try {
            SkytapUtils.checkResponseForErrors(httpRespBody);
        }
        catch (SkytapException e) {
            JenkinsLogger.error("Skytap Error: " + e.getError());
        }
    }

    private String buildRequestURL(String configId, String runstate) {
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(configId);
        sb.append("?runstate=");
        sb.append(runstate);
        return sb.toString();
    }

    private Boolean isConfigStateTransitionValid(String currentState, String targetState) {
        if (currentState.equals("stopped") && targetState.equals("suspended")) {
            return false;
        }
        if (currentState.equals("halted") && targetState.equals("suspended")) {
            return false;
        }
        if (currentState.equals("suspended") && targetState.equals("stopped")) {
            return false;
        }
        return true;
    }

    private String getCurrentConfigurationRunstate(String skytapConfigId) throws SkytapException {
        JenkinsLogger.log("Retrieving Current Runstate ...");
        StringBuilder sb = new StringBuilder("https://cloud.skytap.com/");
        sb.append("configurations/");
        sb.append(skytapConfigId);
        String getRequest = sb.toString();
        HttpGet hg = SkytapUtils.buildHttpGetRequest(getRequest, this.authCredentials);
        String getResponse = "";
        try {
            getResponse = SkytapUtils.executeHttpRequest((HttpRequestBase)hg);
        }
        catch (Exception e) {
            throw new SkytapException(e.getMessage());
        }
        String skytapRunstate = "";
        try {
            skytapRunstate = SkytapUtils.getValueFromJsonResponseBody(getResponse, "runstate");
        }
        catch (NullPointerException ex) {
            throw new SkytapException("Response was null or empty.");
        }
        return skytapRunstate;
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public String getTargetRunState() {
        return this.targetRunState;
    }

    public Boolean getHaltOnFailedShutdown() {
        return this.haltOnFailedShutdown;
    }
}

