/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.skype.im.transport.callables;

import com.skype.Chat;
import com.skype.ChatMessage;
import com.skype.ChatMessageListener;
import com.skype.SkypeException;
import com.skype.SkypeImpl;
import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.skype.im.transport.SkypeChat;
import hudson.plugins.skype.im.transport.SkypeIMException;
import hudson.plugins.skype.im.transport.SkypeMessage;
import hudson.plugins.skype.im.transport.callables.BotCommandCallable;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkypeSetupCallable
implements Callable<Boolean, SkypeIMException> {
    static Collection<String> supportedArchs = null;

    public Boolean call() throws SkypeIMException {
        try {
            if (!supportedArchs.contains(System.getProperty("os.arch"))) {
                throw new RuntimeException("Cannot use skype server on a 64 bit jvm (" + System.getProperty("os.arch") + ")");
            }
            if (!SkypeImpl.isInstalled()) {
                throw new RuntimeException("Skype not installed.");
            }
            if (!SkypeImpl.isRunning()) {
                System.err.println("Skype is probably not running");
            }
            SkypeImpl.setDebug(true);
            SkypeImpl.setDaemon(true);
            this.addSkypeListener(Channel.current());
            return true;
        }
        catch (SkypeException ex) {
            throw new SkypeIMException(ex);
        }
    }

    private void addSkypeListener(Channel channel) throws SkypeException {
        final IMListener listener = new IMListener(channel);
        SkypeImpl.addChatMessageListener(listener);
        if (channel != null) {
            channel.addListener(new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    SkypeImpl.removeChatMessageListener(listener);
                    System.err.println("Removed skype listener");
                }
            });
        }
    }

    static {
        supportedArchs = new ArrayList<String>();
        supportedArchs.add("x86");
        supportedArchs.add("i386");
        supportedArchs.add("i586");
    }

    private final class IMListener
    implements ChatMessageListener {
        Channel masterChannel = null;

        public IMListener(Channel channel) {
            this.masterChannel = channel;
        }

        public void chatMessageReceived(ChatMessage receivedChatMessage) throws SkypeException {
            if (receivedChatMessage.getType().equals((Object)ChatMessage.Type.SAID)) {
                Logger.getLogger(this.getClass().getName()).info("Message from " + receivedChatMessage.getSenderDisplayName() + " : " + receivedChatMessage.getContent());
                String chatPartner = receivedChatMessage.getSenderId();
                this.getChat(chatPartner, receivedChatMessage);
            }
        }

        public void chatMessageSent(ChatMessage sentChatMessage) throws SkypeException {
        }

        private void getChat(String chatPartner, ChatMessage receivedChatMessage) {
            try {
                Chat chat = receivedChatMessage.getChat();
                if (this.masterChannel != null) {
                    this.masterChannel.call((Callable)new BotCommandCallable(chat, receivedChatMessage));
                } else {
                    SkypeChat skypeChat = new SkypeChat(chat);
                    Bot bot = new Bot((IMChat)skypeChat, "hudson", "hostname", "!", null);
                    if (receivedChatMessage != null) {
                        bot.onMessage((IMMessage)new SkypeMessage(receivedChatMessage, true));
                    }
                }
            }
            catch (SkypeException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
    }
}

