/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.skype.im.transport.callables;

import com.skype.Chat;
import com.skype.ChatMessage;
import com.skype.SkypeException;
import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.skype.im.transport.SkypeChat;
import hudson.plugins.skype.im.transport.SkypeIMException;
import hudson.plugins.skype.im.transport.callables.SkypeChatCallable;
import hudson.remoting.Callable;
import hudson.remoting.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BotCommandCallable
implements Callable<Boolean, SkypeIMException> {
    Chat chat = null;
    String senderId = null;
    String toId = null;
    String content = null;

    public BotCommandCallable(Chat chat, ChatMessage msg) throws SkypeIMException {
        this.chat = chat;
        try {
            this.senderId = msg.getSenderId();
            this.toId = msg.getId();
            this.content = msg.getContent();
        }
        catch (SkypeException e) {
            throw new SkypeIMException(e);
        }
    }

    public Boolean call() throws SkypeIMException {
        SkypeChat skypeChat = new SkypeChat(this.chat){

            public void sendMessage(String msg) throws IMException {
                try {
                    SkypeChatCallable sender = new SkypeChatCallable(new String[]{BotCommandCallable.this.senderId}, msg);
                    Channel.current().call((Callable)sender);
                }
                catch (Exception ex) {
                    throw new IMException(ex);
                }
            }
        };
        Bot bot = new Bot((IMChat)skypeChat, "hudson", "hostname", "!", null);
        if (this.content != null) {
            bot.onMessage(new IMMessage(this.senderId, this.toId, this.content));
        }
        return Boolean.TRUE;
    }
}

