/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.skype.im.transport;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.MatrixJobMultiplier;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.skype.im.transport.SkypeIMConnectionProvider;
import hudson.plugins.skype.im.transport.SkypePublisher;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkypePublisherDescriptor
extends BuildStepDescriptor<Publisher>
implements IMPublisherDescriptor {
    private static final Logger LOGGER = Logger.getLogger(SkypePublisherDescriptor.class.getName());
    private static final String PREFIX = "skypePlugin.";
    public static final String PARAMETERNAME_ENABLED = "skypePlugin.enabled";
    public static final String PARAMETERNAME_PORT = "skypePlugin.port";
    public static final String PARAMETERNAME_PRESENCE = "skypePlugin.exposePresence";
    public static final String PARAMETERNAME_GROUP_NICKNAME = "skypePlugin.groupNick";
    public static final String PARAMETERNAME_TARGETS = "skypePlugin.targets";
    public static final String PARAMETERNAME_STRATEGY = "skypePlugin.strategy";
    public static final String PARAMETERNAME_NOTIFY_START = "skypePlugin.notifyStart";
    public static final String PARAMETERNAME_NOTIFY_SUSPECTS = "skypePlugin.notifySuspects";
    public static final String PARAMETERNAME_NOTIFY_CULPRITS = "skypePlugin.notifyCulprits";
    public static final String PARAMETERNAME_NOTIFY_FIXERS = "skypePlugin.notifyFixers";
    public static final String PARAMETERNAME_NOTIFY_UPSTREAM_COMMITTERS = "skypePlugin.notifyUpstreamCommitters";
    public static final String PARAMETERNAME_INITIAL_GROUPCHATS = "skypePlugin.initialGroupChats";
    public static final String PARAMETERNAME_COMMAND_PREFIX = "skypePlugin.commandPrefix";
    public static final String PARAMETERNAME_DEFAULT_ID_SUFFIX = "skypePlugin.defaultIdSuffix";
    public static final String PARAMETERNAME_HUDSON_LOGIN = "skypePlugin.hudsonLogin";
    public static final String PARAMETERNAME_HUDSON_PASSWORD = "skypePlugin.hudsonPassword";
    public static final String[] PARAMETERVALUE_STRATEGY_VALUES = NotificationStrategy.getDisplayNames();
    public static final String PARAMETERVALUE_STRATEGY_DEFAULT = NotificationStrategy.STATECHANGE_ONLY.getDisplayName();
    public static final String DEFAULT_COMMAND_PREFIX = "!";
    private static final int DEFAULT_PORT = 5222;
    private Boolean enabled;
    private int port = 5222;
    private String hostname;
    private String hudsonNickname;
    private String hudsonPassword;
    private String groupChatNickname;
    private boolean exposePresence = true;
    private boolean enableSASL = true;
    private String initialGroupChats;
    private String commandPrefix = "!";
    private String defaultIdSuffix;
    private String hudsonCiLogin;
    private String hudsonCiPassword;

    public SkypePublisherDescriptor() {
        super(SkypePublisher.class);
        this.load();
        if (this.isEnabled()) {
            try {
                SkypeIMConnectionProvider.setDesc(this);
            }
            catch (Exception e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
        } else {
            try {
                SkypeIMConnectionProvider.setDesc(null);
            }
            catch (IMException e) {
                LOGGER.info(ExceptionHelper.dump((Throwable)e));
            }
        }
    }

    public void load() {
        super.load();
        if (this.enabled == null) {
            this.enabled = Util.fixEmptyAndTrim((String)this.hudsonNickname) != null ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private void applyGroupChatNickname(HttpServletRequest req) throws Descriptor.FormException {
        this.groupChatNickname = req.getParameter(PARAMETERNAME_GROUP_NICKNAME);
        if (this.groupChatNickname != null && this.groupChatNickname.trim().length() == 0) {
            this.groupChatNickname = null;
        }
    }

    private void applyPort(HttpServletRequest req) throws Descriptor.FormException {
        String p = Util.fixEmptyAndTrim((String)req.getParameter(PARAMETERNAME_PORT));
        if (p != null) {
            try {
                int i = Integer.parseInt(p);
                if (i < 0 || i > 65535) {
                    throw new Descriptor.FormException("Port out of range.", PARAMETERNAME_PORT);
                }
                this.port = i;
            }
            catch (NumberFormatException e) {
                throw new Descriptor.FormException("Port cannot be parsed.", PARAMETERNAME_PORT);
            }
        } else {
            this.port = 5222;
        }
    }

    private void applyInitialGroupChats(HttpServletRequest req) {
        this.initialGroupChats = Util.fixEmptyAndTrim((String)req.getParameter(PARAMETERNAME_INITIAL_GROUPCHATS));
    }

    private void applyCommandPrefix(HttpServletRequest req) {
        String prefix = req.getParameter(PARAMETERNAME_COMMAND_PREFIX);
        this.commandPrefix = prefix != null && prefix.trim().length() > 0 ? prefix : DEFAULT_COMMAND_PREFIX;
    }

    private void applyDefaultIdSuffix(HttpServletRequest req) {
        String suffix = req.getParameter(PARAMETERNAME_DEFAULT_ID_SUFFIX);
        this.defaultIdSuffix = suffix != null && suffix.trim().length() > 0 ? suffix.trim() : "";
    }

    private void applyHudsonLoginPassword(HttpServletRequest req) throws Descriptor.FormException {
        this.hudsonCiLogin = Util.fixEmptyAndTrim((String)req.getParameter(PARAMETERNAME_HUDSON_LOGIN));
        this.hudsonCiPassword = Util.fixEmptyAndTrim((String)req.getParameter(PARAMETERNAME_HUDSON_PASSWORD));
        if (this.hudsonCiLogin != null) {
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)this.hudsonCiLogin, (Object)this.hudsonCiPassword);
            try {
                Hudson.getInstance().getSecurityRealm().getSecurityComponents().manager.authenticate((Authentication)auth);
            }
            catch (AuthenticationException e) {
                throw new Descriptor.FormException((Throwable)e, "Bad Hudson credentials");
            }
        }
    }

    public String getDisplayName() {
        return "Skype Notification";
    }

    public String getPluginDescription() {
        return "Skype plugin";
    }

    public boolean isEnabled() {
        return Boolean.TRUE.equals(this.enabled);
    }

    @Deprecated
    public String getHostname() {
        return this.hostname;
    }

    public String getSkypeId() {
        return this.hudsonNickname;
    }

    public String getPassword() {
        return this.hudsonPassword;
    }

    public String getGroupChatNickname() {
        return this.groupChatNickname;
    }

    public int getPort() {
        return this.port;
    }

    public String getPortString() {
        if (this.port == 5222) {
            return null;
        }
        return String.valueOf(this.port);
    }

    public boolean isEnableSASL() {
        return this.enableSASL;
    }

    public boolean isExposePresence() {
        return this.exposePresence;
    }

    public String getInitialGroupChats() {
        return Util.fixEmptyAndTrim((String)this.initialGroupChats);
    }

    public String getDefaultIdSuffix() {
        return null;
    }

    public String getCommandPrefix() {
        return this.commandPrefix;
    }

    public SkypePublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        Assert.notNull((Object)req, (String)"Parameter 'req' must not be null.");
        String t = req.getParameter(PARAMETERNAME_TARGETS);
        String[] split = t != null ? t.split("\\s") : new String[]{};
        ArrayList<IMMessageTarget> targets = new ArrayList<IMMessageTarget>(split.length);
        try {
            IMMessageTargetConverter conv = this.getIMMessageTargetConverter();
            for (String fragment : split) {
                IMMessageTarget createIMMessageTarget = conv.fromString(fragment);
                if (createIMMessageTarget == null) continue;
                targets.add(createIMMessageTarget);
            }
        }
        catch (IMMessageTargetConversionException e) {
            throw new Descriptor.FormException("Invalid SkypeID", (Throwable)e, PARAMETERNAME_TARGETS);
        }
        String n = req.getParameter(PARAMETERNAME_STRATEGY);
        if (n == null) {
            n = PARAMETERVALUE_STRATEGY_DEFAULT;
        } else {
            boolean foundStrategyValueMatch = false;
            for (String strategyValue : PARAMETERVALUE_STRATEGY_VALUES) {
                if (!strategyValue.equals(n)) continue;
                foundStrategyValueMatch = true;
                break;
            }
            if (!foundStrategyValueMatch) {
                n = PARAMETERVALUE_STRATEGY_DEFAULT;
            }
        }
        boolean notifyStart = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_START));
        boolean notifySuspects = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_SUSPECTS));
        boolean notifyCulprits = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_CULPRITS));
        boolean notifyFixers = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_FIXERS));
        boolean notifyUpstream = "on".equals(req.getParameter(PARAMETERNAME_NOTIFY_UPSTREAM_COMMITTERS));
        MatrixJobMultiplier matrixJobMultiplier = MatrixJobMultiplier.ONLY_CONFIGURATIONS;
        if (formData.has("matrixNotifier")) {
            String o = formData.getString("matrixNotifier");
            matrixJobMultiplier = MatrixJobMultiplier.valueOf((String)o);
        }
        return new SkypePublisher(targets, n, notifyStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstream, (BuildToChatNotifier)req.bindJSON(BuildToChatNotifier.class, formData.getJSONObject("buildToChatNotifier")), matrixJobMultiplier);
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        String en = req.getParameter(PARAMETERNAME_ENABLED);
        this.enabled = en != null;
        this.exposePresence = req.getParameter(PARAMETERNAME_PRESENCE) != null;
        this.applyPort((HttpServletRequest)req);
        this.applyGroupChatNickname((HttpServletRequest)req);
        this.applyInitialGroupChats((HttpServletRequest)req);
        this.applyCommandPrefix((HttpServletRequest)req);
        this.applyDefaultIdSuffix((HttpServletRequest)req);
        this.applyHudsonLoginPassword((HttpServletRequest)req);
        if (this.isEnabled()) {
            try {
                SkypeIMConnectionProvider.setDesc(this);
                SkypeIMConnectionProvider.getInstance().currentConnection();
            }
            catch (Exception e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)e));
            }
        } else {
            SkypeIMConnectionProvider.getInstance().releaseConnection();
            try {
                SkypeIMConnectionProvider.setDesc(null);
            }
            catch (IMException e) {
                LOGGER.info(ExceptionHelper.dump((Throwable)e));
            }
            LOGGER.info("No hostname specified.");
        }
        this.save();
        return super.configure(req, json);
    }

    public FormValidation doServerCheck(@QueryParameter String hostname, @QueryParameter String port) {
        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return FormValidation.ok();
        }
        String host = Util.fixEmptyAndTrim((String)hostname);
        String p = Util.fixEmptyAndTrim((String)port);
        if (host == null) {
            return FormValidation.ok();
        }
        try {
            SkypePublisherDescriptor.checkHostAccessibility(host, port);
            return FormValidation.ok();
        }
        catch (UnknownHostException e) {
            return FormValidation.error((String)("Unknown host " + host));
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)("Invalid port " + port));
        }
        catch (IOException e) {
            return FormValidation.error((String)("Unable to connect to " + hostname + ":" + p + " : " + e.getMessage()));
        }
    }

    private static void checkHostAccessibility(String hostname, String port) throws UnknownHostException, IOException, NumberFormatException {
        hostname = Util.fixEmptyAndTrim((String)hostname);
        port = Util.fixEmptyAndTrim((String)port);
        int iPort = 5222;
        InetAddress address = InetAddress.getByName(hostname);
        if (port != null) {
            iPort = Integer.parseInt(port);
        }
        Socket s = new Socket(address, iPort);
        s.close();
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getUserName() {
        return this.getSkypeId();
    }

    public String getHudsonPassword() {
        return this.hudsonCiPassword;
    }

    public String getHudsonUserName() {
        return this.hudsonCiLogin;
    }

    public IMMessageTargetConverter getIMMessageTargetConverter() {
        return SkypePublisher.CONVERTER;
    }

    public List<IMMessageTarget> getDefaultTargets() {
        return Collections.emptyList();
    }

    public String getHost() {
        return "localhost";
    }
}

