/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.skype.im.transport;

import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.im.DefaultIMMessageTarget;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.MatrixJobMultiplier;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.skype.im.transport.SkypeIMConnection;
import hudson.plugins.skype.im.transport.SkypeIMConnectionProvider;
import hudson.plugins.skype.im.transport.SkypePublisherDescriptor;
import hudson.plugins.skype.im.transport.callables.SkypeVerifyUserCallable;
import hudson.plugins.skype.user.SkypeUserProperty;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Mailer;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.List;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkypePublisher
extends IMPublisher {
    @Extension
    public static final SkypePublisherDescriptor DESCRIPTOR = new SkypePublisherDescriptor();
    static final IMMessageTargetConverter CONVERTER = new SkypeIMMessageTargetConverter();

    public SkypePublisher(List<IMMessageTarget> defaultTargets, String notificationStrategyString, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters, BuildToChatNotifier buildToChatNotifier, MatrixJobMultiplier matrixMultiplier) {
        super(defaultTargets, notificationStrategyString, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstreamCommitters, buildToChatNotifier, matrixMultiplier);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    protected IMConnection getIMConnection() throws IMException {
        return SkypeIMConnectionProvider.getInstance().currentConnection();
    }

    protected String getPluginName() {
        return "Skype notifier plugin";
    }

    protected String getConfiguredIMId(User user) {
        SkypeUserProperty skypeUserProperty = (SkypeUserProperty)((Object)user.getProperties().get((Object)SkypeUserProperty.DESCRIPTOR));
        String result = null;
        if (skypeUserProperty != null && skypeUserProperty.getSkypeId() != null && skypeUserProperty.getSkypeId().length() > 0) {
            result = skypeUserProperty.getSkypeId();
        } else {
            try {
                Mailer.UserProperty prop = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
                System.out.println("TRying " + prop);
                if (prop != null) {
                    SkypeVerifyUserCallable callable = new SkypeVerifyUserCallable(prop.getAddress());
                    result = (String)((SkypeIMConnection)this.getIMConnection()).getChannel().call((Callable)callable);
                    user.addProperty((UserProperty)new SkypeUserProperty(result));
                    user.save();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    public String getTargets() {
        List notificationTargets = this.getNotificationTargets();
        StringBuilder sb = new StringBuilder();
        for (IMMessageTarget target : notificationTargets) {
            if (target instanceof GroupChatIMMessageTarget && !target.toString().contains("@conference.")) {
                sb.append("*");
            }
            sb.append(this.getIMDescriptor().getIMMessageTargetConverter().toString(target));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    private static class SkypeIMMessageTargetConverter
    implements IMMessageTargetConverter {
        private SkypeIMMessageTargetConverter() {
        }

        private void checkValidity(String f) throws IMMessageTargetConversionException {
        }

        public IMMessageTarget fromString(String targetAsString) throws IMMessageTargetConversionException {
            String f = targetAsString.trim();
            if (f.length() > 0) {
                Object target;
                if (f.startsWith("*")) {
                    f = f.substring(1);
                    target = new GroupChatIMMessageTarget(f);
                } else {
                    target = f.contains("@conference.") ? new GroupChatIMMessageTarget(f) : new DefaultIMMessageTarget(f);
                }
                this.checkValidity(f);
                return target;
            }
            return null;
        }

        public String toString(IMMessageTarget target) {
            Assert.notNull((Object)target, (String)"Parameter 'target' must not be null.");
            return target.toString();
        }
    }
}

