/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.skype.im.transport;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMConnectionProvider;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.skype.im.transport.SkypeIMConnection;
import hudson.plugins.skype.im.transport.SkypePublisherDescriptor;
import hudson.slaves.ComputerListener;
import java.io.IOException;

final class SkypeIMConnectionProvider
extends IMConnectionProvider {
    private static final SkypeIMConnectionProvider INSTANCE = new SkypeIMConnectionProvider();

    private SkypeIMConnectionProvider() {
    }

    static SkypeIMConnectionProvider getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDesc(IMPublisherDescriptor desc) throws IMException {
        SkypeIMConnectionProvider skypeIMConnectionProvider = INSTANCE;
        synchronized (skypeIMConnectionProvider) {
            INSTANCE.setDescriptor(desc);
        }
    }

    public void setDescriptor(IMPublisherDescriptor desc) {
        super.setDescriptor(desc);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMConnection createConnection() throws IMException {
        SkypeIMConnectionProvider skypeIMConnectionProvider = INSTANCE;
        synchronized (skypeIMConnectionProvider) {
            if (this.getDescriptor() == null) {
                throw new RuntimeException("No descriptor");
            }
            SkypeIMConnection imConnection = new SkypeIMConnection((SkypePublisherDescriptor)this.getDescriptor(), null);
            if (imConnection.connect()) {
                return imConnection;
            }
        }
        throw new IMException("Connection failed");
    }

    @Extension
    public static class SkypeComputerListener
    extends ComputerListener {
        public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
            if (c.getNode().getLabelString().contains("skype")) {
                SkypeIMConnectionProvider.getInstance().connectionBroken(null);
                System.out.println("Node came online, retry");
            }
        }
    }
}

