/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.skype.im.transport;

import com.skype.Profile;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.im.AbstractIMConnection;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMPresence;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.skype.im.transport.SkypeIMException;
import hudson.plugins.skype.im.transport.SkypePublisherDescriptor;
import hudson.plugins.skype.im.transport.callables.SkypeChatCallable;
import hudson.plugins.skype.im.transport.callables.SkypeGroupChatCallable;
import hudson.plugins.skype.im.transport.callables.SkypeMoodCallable;
import hudson.plugins.skype.im.transport.callables.SkypeSetupCallable;
import hudson.plugins.skype.im.transport.callables.SkypeVerifyUserCallable;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.event.ConnectionListener;
import org.acegisecurity.Authentication;
import org.springframework.util.Assert;

class SkypeIMConnection
extends AbstractIMConnection {
    private static final Logger LOGGER = Logger.getLogger(SkypeIMConnection.class.getName());
    private final Set<Bot> bots = new HashSet<Bot>();
    private final String passwd;
    private final String botCommandPrefix;
    private final String nick = "hudson";
    private final String groupChatNick;
    private final String hostname;
    private final int port;
    private final String[] groupChats;
    private IMPresence impresence;
    private String imStatusMessage;
    private final SkypePublisherDescriptor desc;
    private final Authentication authentication;
    private Node skypeSlave = null;
    private final Map<IMConnectionListener, ConnectionListener> listeners = new ConcurrentHashMap<IMConnectionListener, ConnectionListener>();

    SkypeIMConnection(SkypePublisherDescriptor desc, Authentication authentication) throws IMException {
        super((IMPublisherDescriptor)desc);
        Assert.notNull((Object)((Object)desc), (String)"Parameter 'desc' must not be null.");
        this.desc = desc;
        this.authentication = authentication;
        this.hostname = desc.getHost();
        this.port = desc.getPort();
        this.passwd = desc.getPassword();
        this.groupChatNick = desc.getGroupChatNickname() != null ? desc.getGroupChatNickname() : this.nick;
        this.botCommandPrefix = desc.getCommandPrefix();
        this.groupChats = desc.getInitialGroupChats() != null ? desc.getInitialGroupChats().trim().split("\\s") : new String[0];
        this.impresence = desc.isExposePresence() ? IMPresence.AVAILABLE : IMPresence.UNAVAILABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        boolean connected;
        block6: {
            this.lock();
            connected = false;
            try {
                try {
                    if (this.isConnected()) break block6;
                    if (this.createConnection()) {
                        LOGGER.info("Connected to Skype");
                        this.sendPresence();
                        connected = true;
                        break block6;
                    }
                    LOGGER.warning("Cannot connect to Skype");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.warning(ExceptionHelper.dump((Throwable)e));
                }
            }
            finally {
                this.unlock();
            }
        }
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock();
        this.unlock();
    }

    private synchronized boolean createConnection() throws IMException {
        System.err.println("createConnection ");
        Boolean result = Boolean.FALSE;
        if (!System.getProperty("os.arch").contains("x86")) {
            Label labelToFind = Label.get((String)"skype");
            if (labelToFind.isAssignable()) {
                for (Node node : labelToFind.getNodes()) {
                    if (!this.verifySlave((Node)((Slave)node)).booleanValue()) continue;
                    result = Boolean.TRUE;
                    break;
                }
            } else {
                Logger.getLogger(SkypeIMConnection.class.getName()).log(Level.SEVERE, "Cannot find nodes with label skype");
            }
        } else {
            Hudson hudson = Hudson.getInstance();
            result = this.verifySlave((Node)hudson);
        }
        return result;
    }

    private Boolean verifySlave(Node slave) {
        SkypeSetupCallable callable = new SkypeSetupCallable();
        Boolean result = false;
        Computer comp = slave.toComputer();
        if (slave != null && comp != null && comp.isAcceptingTasks()) {
            try {
                result = (Boolean)slave.getChannel().call((Callable)callable);
                if (result.booleanValue()) {
                    if (slave.getChannel() instanceof Channel) {
                        ((Channel)slave.getChannel()).addListener(new Channel.Listener(){

                            public void onClosed(Channel channel, IOException cause) {
                                SkypeIMConnection.this.skypeSlave = null;
                            }
                        });
                    }
                    this.skypeSlave = slave;
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SkypeIMConnection.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SkypeIMConnection.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            result = Boolean.FALSE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IMMessageTarget target, String text) throws IMException {
        Assert.notNull((Object)target, (String)"Parameter 'target' must not be null.");
        Assert.notNull((Object)text, (String)"Parameter 'text' must not be null.");
        LOGGER.info("Send to " + target + " val " + text);
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                SkypeChatCallable msgCallable;
                if (target instanceof GroupChatIMMessageTarget) {
                    System.out.println("Group:" + target);
                    msgCallable = new SkypeGroupChatCallable(target.toString(), text);
                } else {
                    this.verifyUser(target);
                    msgCallable = new SkypeChatCallable(new String[]{target.toString()}, text);
                }
                try {
                    this.getChannel().call((Callable)msgCallable);
                }
                catch (IOException ex) {
                    throw new SkypeIMException(ex);
                }
                catch (InterruptedException ex) {
                    throw new SkypeIMException(ex);
                }
            }
            catch (SkypeIMException e) {
                LOGGER.warning(ExceptionHelper.dump((Throwable)((Object)e)));
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public VirtualChannel getChannel() {
        if (this.skypeSlave != null && this.skypeSlave.toComputer() != null && this.skypeSlave.toComputer().isOnline()) {
            return this.skypeSlave.getChannel();
        }
        return null;
    }

    private void verifyUser(IMMessageTarget target) throws SkypeIMException {
        try {
            SkypeVerifyUserCallable callable = new SkypeVerifyUserCallable(target.toString());
            String result = (String)this.getChannel().call((Callable)callable);
            if (result != null) {
                throw new SkypeIMException("Could not find user " + target);
            }
        }
        catch (IOException ex) {
            throw new SkypeIMException(ex);
        }
        catch (InterruptedException ex) {
            throw new SkypeIMException(ex);
        }
    }

    public void setPresence(IMPresence impresence, String statusMessage) throws IMException {
        Assert.notNull((Object)impresence, (String)"Parameter 'impresence' must not be null.");
        if (this.desc.isExposePresence()) {
            this.impresence = impresence;
            this.imStatusMessage = statusMessage;
            this.sendPresence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPresence() {
        try {
            if (!this.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
            try {
                Profile.Status presence;
                if (!this.isConnected()) {
                    return;
                }
                switch (this.impresence) {
                    case AVAILABLE: {
                        presence = Profile.Status.ONLINE;
                        break;
                    }
                    case OCCUPIED: {
                        presence = Profile.Status.AWAY;
                        break;
                    }
                    case DND: {
                        presence = Profile.Status.DND;
                        break;
                    }
                    case UNAVAILABLE: {
                        presence = Profile.Status.OFFLINE;
                        break;
                    }
                    default: {
                        presence = Profile.Status.UNKNOWN;
                    }
                }
                SkypeMoodCallable callable = new SkypeMoodCallable(this.imStatusMessage, presence);
                try {
                    this.getChannel().call((Callable)callable);
                }
                catch (IOException ex) {
                    Logger.getLogger(SkypeIMConnection.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        this.lock();
        boolean conn = false;
        try {
            conn = this.getChannel() != null;
        }
        finally {
            this.unlock();
        }
        return conn;
    }

    public boolean isAuthorized(String xmppAddress) throws SkypeIMException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(IMConnectionListener listener) {
        this.lock();
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(IMConnectionListener listener) {
        this.lock();
        this.unlock();
    }
}

