/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.windows;

import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorStatusEvent;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Display;

public final class WindowsConnector
extends Connector {
    private static final int ATTACH_SUCCESS = 0;
    private static final int ATTACH_PENDING_AUTHORIZATION = 1;
    private static final int ATTACH_REFUSED = 2;
    private static final int ATTACH_NOT_AVAILABLE = 3;
    private static final int ATTACH_API_AVAILABLE = 32769;
    private static final int HWND_BROADCAST = 65535;
    private static final int WM_COPYDATA = 74;
    private static final int ATTACH_MESSAGE_ID = OS.RegisterWindowMessage((TCHAR)new TCHAR(0, "SkypeControlAPIAttach", true));
    private static final int DISCOVER_MESSAGE_ID = OS.RegisterWindowMessage((TCHAR)new TCHAR(0, "SkypeControlAPIDiscover", true));
    private Display display;
    private TCHAR windowClass;
    private int windowHandle;
    private int skypeWindowHandle;
    private Thread eventLoop;
    private CountDownLatch eventLoopFinishedLatch;

    public static WindowsConnector getInstance() {
        return Instance.instance;
    }

    private WindowsConnector() {
    }

    public String getInstalledPath() {
        String result = this.getRegistryValue(-2147483647, "Software\\Skype\\Phone", "SkypePath");
        if (result == null) {
            result = this.getRegistryValue(-2147483646, "Software\\Skype\\Phone", "SkypePath");
        }
        return result;
    }

    private String getRegistryValue(int hKey, String keyName, String dataName) {
        int[] phkResult = new int[1];
        if (OS.RegOpenKeyEx((int)hKey, (TCHAR)new TCHAR(0, keyName, true), (int)0, (int)131097, (int[])phkResult) != 0) {
            return null;
        }
        String result = null;
        int[] lpcbData = new int[1];
        if (OS.RegQueryValueEx((int)phkResult[0], (TCHAR)new TCHAR(0, dataName, true), (int)0, null, (TCHAR)null, (int[])lpcbData) == 0) {
            TCHAR lpData;
            result = "";
            int length = lpcbData[0] / TCHAR.sizeof;
            if (length != 0 && OS.RegQueryValueEx((int)phkResult[0], (TCHAR)new TCHAR(0, dataName, true), (int)0, null, (TCHAR)(lpData = new TCHAR(0, length)), (int[])lpcbData) == 0) {
                length = Math.max(0, lpData.length() - 1);
                result = lpData.toString(0, length);
            }
        }
        if (phkResult[0] != 0) {
            OS.RegCloseKey((int)phkResult[0]);
        }
        return result;
    }

    public boolean isRunning() throws ConnectorException {
        try {
            Class<?> clazz = Class.forName("com.skype.connector.windows.SkypeFramework");
            Method method = clazz.getDeclaredMethod("isRunning", new Class[0]);
            return (Boolean)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("The winp-1.5.jar <https://winp.dev.java.net/> is not contained in the classpath.", e);
        }
    }

    protected void initializeImpl() throws ConnectorException {
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] errorMessage = new String[1];
        this.eventLoopFinishedLatch = new CountDownLatch(1);
        this.eventLoop = new Thread("SkypeEventLoop"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    WindowsConnector.this.display = new Display();
                    WindowsConnector.this.windowClass = new TCHAR(0, "" + System.currentTimeMillis() + (int)(Math.random() * 1000.0), true);
                    int messageReceived = new Callback((Object)WindowsConnector.this, "messageReceived", 4).getAddress();
                    if (messageReceived == 0) {
                        this.setErrorMessage("The Windows connector couldn't get a callback resource.");
                        return;
                    }
                    int hHeap = OS.GetProcessHeap();
                    if (hHeap == 0) {
                        this.setErrorMessage("The Windows connector couldn't get the heap handle.");
                        return;
                    }
                    int hInstance = OS.GetModuleHandle(null);
                    if (hInstance == 0) {
                        this.setErrorMessage("The Windows connector couldn't get the module handle.");
                        return;
                    }
                    WNDCLASS lpWndClass = new WNDCLASS();
                    lpWndClass.hInstance = hInstance;
                    lpWndClass.lpfnWndProc = messageReceived;
                    lpWndClass.style = 8200;
                    lpWndClass.hCursor = OS.LoadCursor((int)0, (int)32512);
                    if (lpWndClass.hCursor == 0) {
                        this.setErrorMessage("The Windows connector couldn't get a cursor handle.");
                        return;
                    }
                    int byteCount = WindowsConnector.this.windowClass.length() * TCHAR.sizeof;
                    lpWndClass.lpszClassName = OS.HeapAlloc((int)hHeap, (int)8, (int)byteCount);
                    if (lpWndClass.lpszClassName == 0) {
                        this.setErrorMessage("The Windows connector couldn't get a resource.");
                        return;
                    }
                    OS.MoveMemory((int)lpWndClass.lpszClassName, (TCHAR)WindowsConnector.this.windowClass, (int)byteCount);
                    if (OS.RegisterClass((WNDCLASS)lpWndClass) == 0) {
                        this.setErrorMessage("The Windows connector couldn't register a window class.");
                        return;
                    }
                    WindowsConnector.this.windowHandle = OS.CreateWindowEx((int)0, (TCHAR)WindowsConnector.this.windowClass, null, (int)OS.WS_OVERLAPPED, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)hInstance, null);
                    if (WindowsConnector.this.windowHandle == 0) {
                        this.setErrorMessage("The Windows connector couldn't create a window.");
                        return;
                    }
                }
                finally {
                    latch.countDown();
                }
                while (true) {
                    if (WindowsConnector.this.display.readAndDispatch()) {
                        continue;
                    }
                    WindowsConnector.this.display.sleep();
                    if (Thread.currentThread().isInterrupted()) break;
                }
                WindowsConnector.this.eventLoopFinishedLatch.countDown();
            }

            private void setErrorMessage(String message) {
                errorMessage[0] = message;
            }
        };
        this.eventLoop.setDaemon(true);
        this.eventLoop.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new ConnectorException("The Windows connector initialization was interrupted.", e);
        }
        if (errorMessage[0] != null) {
            throw new ConnectorException(errorMessage[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connector.Status connect(int timeout) throws ConnectorException {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        AbstractConnectorListener listener = new AbstractConnectorListener(){

            public void statusChanged(ConnectorStatusEvent event) {
                queue.add(event.getStatus());
            }
        };
        this.addConnectorListener(listener, false);
        try {
            while (true) {
                OS.PostMessage((int)65535, (int)DISCOVER_MESSAGE_ID, (int)this.windowHandle, (int)0);
                Connector.Status status = (Connector.Status)((Object)queue.poll(timeout, TimeUnit.MILLISECONDS));
                if (status == null) {
                    this.setStatus(Connector.Status.NOT_RUNNING);
                }
                if (status != Connector.Status.PENDING_AUTHORIZATION) {
                    Connector.Status status2 = status;
                    return status2;
                }
                Thread.sleep(1000L);
                continue;
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConnectorException("Trying to connect was interrupted.", e);
        }
        finally {
            this.removeConnectorListener(listener);
        }
    }

    protected void sendApplicationName(String applicationName) throws ConnectorException {
        String command = "NAME " + applicationName;
        this.execute(command, new String[]{command}, false);
    }

    private int messageReceived(int hwnd, int msg, int wParam, int lParam) {
        if (msg == ATTACH_MESSAGE_ID) {
            switch (lParam) {
                case 1: {
                    this.setStatus(Connector.Status.PENDING_AUTHORIZATION);
                    break;
                }
                case 0: {
                    this.skypeWindowHandle = wParam;
                    this.setStatus(Connector.Status.ATTACHED);
                    break;
                }
                case 2: {
                    this.setStatus(Connector.Status.REFUSED);
                    break;
                }
                case 3: {
                    this.setStatus(Connector.Status.NOT_AVAILABLE);
                    break;
                }
                case 32769: {
                    this.setStatus(Connector.Status.API_AVAILABLE);
                    break;
                }
                default: {
                    this.setStatus(Connector.Status.NOT_RUNNING);
                }
            }
            return 1;
        }
        if (msg == 74 && wParam == this.skypeWindowHandle) {
            int[] data = new int[3];
            OS.MoveMemory((int[])data, (int)lParam, (int)12);
            int cbData = data[1];
            int lpData = data[2];
            int length = cbData;
            byte[] buffer = new byte[length];
            OS.MoveMemory((byte[])buffer, (int)lpData, (int)length);
            byte[] string = new byte[buffer.length - 1];
            System.arraycopy(buffer, 0, string, 0, string.length);
            try {
                String message = new String(string, "UTF-8");
                this.fireMessageReceived(message);
                return 1;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return OS.DefWindowProc((int)hwnd, (int)msg, (int)wParam, (int)lParam);
    }

    protected void disposeImpl() {
        this.eventLoop.interrupt();
        this.display.wake();
        try {
            this.eventLoopFinishedLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void sendCommand(final String command) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                try {
                    byte[] data = (command + "\u0000").getBytes("UTF-8");
                    int hHeap = OS.GetProcessHeap();
                    int pMessage = OS.HeapAlloc((int)hHeap, (int)8, (int)data.length);
                    OS.MoveMemory((int)pMessage, (byte[])data, (int)data.length);
                    OS.SendMessage((int)WindowsConnector.this.skypeWindowHandle, (int)74, (int)WindowsConnector.this.windowHandle, (int[])new int[]{0, data.length, pMessage});
                    OS.HeapFree((int)hHeap, (int)0, (int)pMessage);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        });
    }

    private static class Instance {
        static WindowsConnector instance = new WindowsConnector();

        private Instance() {
        }
    }
}

