/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.test;

import com.skype.SkypeImpl;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import com.skype.connector.test.Player;
import com.skype.connector.test.PlayerMessage;
import com.skype.connector.test.Recorder;
import java.util.ArrayList;
import java.util.List;

public final class TestConnector
extends Connector {
    private Object recordingFieldsMutex = new Object();
    private ConnectorListener recordListener;
    private List<Recorder> recorderList;
    private Recorder[] recorders = new Recorder[0];
    private Object playingFieldsMutex = new Object();
    private Player player;
    private ConnectorListener playingLister;
    private Thread playerThread;
    private Object sentMessageFieldsMutex = new Object();
    private String sentMessage = null;

    public static TestConnector getInstance() {
        return Holder.instance;
    }

    private TestConnector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecorder(Recorder recorder) throws ConnectorException {
        Object object = this.recordingFieldsMutex;
        synchronized (object) {
            Connector.getInstance().connect();
            if (this.recordListener == null) {
                this.recordListener = new AbstractConnectorListener(){

                    public void messageSent(ConnectorMessageEvent event) {
                        Recorder[] recorders;
                        long time = System.currentTimeMillis();
                        for (Recorder recorder : recorders = TestConnector.this.recorders) {
                            recorder.recordSentMessage(time - recorder.getStartTime(), event.getMessage());
                        }
                    }

                    public void messageReceived(ConnectorMessageEvent event) {
                        Recorder[] recorders;
                        long time = System.currentTimeMillis();
                        for (Recorder recorder : recorders = TestConnector.this.recorders) {
                            recorder.recordReceivedMessage(time - recorder.getStartTime(), event.getMessage());
                        }
                    }
                };
                Connector.getInstance().addConnectorListener(this.recordListener, false, true);
            }
            if (this.recorderList == null) {
                this.recorderList = new ArrayList<Recorder>();
            }
            if (!this.recorderList.contains(recorder)) {
                this.recorderList.add(recorder);
                this.recorders = this.recorderList.toArray(new Recorder[0]);
                if (!recorder.isStarted()) {
                    recorder.setStartTime(System.currentTimeMillis());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecorder(Recorder recorder) throws ConnectorException {
        Object object = this.recordingFieldsMutex;
        synchronized (object) {
            if (!this.recorderList.contains(recorder)) {
                return;
            }
            this.recorderList.remove(recorder);
            this.recorders = this.recorderList.toArray(new Recorder[0]);
            if (this.recorderList.isEmpty()) {
                this.recorderList = null;
                Connector.getInstance().removeConnectorListener(this.recordListener);
                this.recordListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayer(final Player player) throws ConnectorException {
        Object object = this.playingFieldsMutex;
        synchronized (object) {
            Connector.setInstance(this);
            Connector.getInstance().connect();
            if (this.player != null) {
                this.clearPlayer();
            }
            this.player = player;
            this.playingLister = new AbstractConnectorListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void messageSent(ConnectorMessageEvent event) {
                    if (event.getMessage().startsWith("PROTOCOL ")) {
                        return;
                    }
                    Object object = TestConnector.this.sentMessageFieldsMutex;
                    synchronized (object) {
                        while (TestConnector.this.sentMessage != null) {
                            try {
                                TestConnector.this.sentMessageFieldsMutex.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        TestConnector.this.sentMessage = event.getMessage();
                        TestConnector.this.sentMessageFieldsMutex.notify();
                    }
                }
            };
            Connector.getInstance().addConnectorListener(this.playingLister, false, true);
            this.playerThread = new Thread("TestConnectorPlayer"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        player.init();
                        long startTime = System.currentTimeMillis();
                        do {
                            if (!player.hasNextMessage()) return;
                            PlayerMessage message = player.getNextMessage();
                            switch (message.getType()) {
                                case SENT: {
                                    Object object = TestConnector.this.sentMessageFieldsMutex;
                                    synchronized (object) {
                                        while (TestConnector.this.sentMessage == null) {
                                            try {
                                                TestConnector.this.sentMessageFieldsMutex.wait();
                                            }
                                            catch (InterruptedException e) {
                                                Thread.currentThread().interrupt();
                                                // MONITOREXIT @DISABLED, blocks:[0, 17, 18, 8, 9, 10, 13] lbl17 : MonitorExitStatement: MONITOREXIT : var4_3
                                                player.destory();
                                                return;
                                            }
                                        }
                                        String sentMessage = TestConnector.this.sentMessage;
                                        TestConnector.this.sentMessage = null;
                                        TestConnector.this.sentMessageFieldsMutex.notify();
                                        if (!message.getMessage().equals(sentMessage)) {
                                            throw new IllegalStateException("The sent message (=\"" + sentMessage + "\")is not equal to the expected message (=\"" + message.getMessage() + "\").");
                                        }
                                        break;
                                    }
                                }
                                case RECEIVED: {
                                    long period = System.currentTimeMillis() - startTime - message.getTime();
                                    if (period < 0L) {
                                        try {
                                            Thread.sleep(-period);
                                        }
                                        catch (InterruptedException e) {
                                            Thread.currentThread().interrupt();
                                            player.destory();
                                            return;
                                        }
                                    }
                                    TestConnector.this.fireMessageReceived(message.getMessage());
                                    break;
                                }
                            }
                        } while (!Thread.currentThread().isInterrupted());
                        return;
                    }
                    finally {
                        player.destory();
                    }
                }
            };
            this.playerThread.setDaemon(true);
            this.playerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPlayer() throws ConnectorException {
        Object object = this.playingFieldsMutex;
        synchronized (object) {
            this.playerThread.interrupt();
            this.playerThread = null;
            Connector.getInstance().removeConnectorListener(this.playingLister);
            this.playingLister = null;
            this.player = null;
            Connector.setInstance(null);
        }
    }

    protected void initializeImpl() throws ConnectorException {
        this.setStatus(Connector.Status.ATTACHED);
    }

    protected Connector.Status connect(int timeout) throws ConnectorException {
        return this.getStatus();
    }

    protected void sendCommand(String command) {
        if (command.equals("PROTOCOL 9999")) {
            this.fireMessageReceived("PROTOCOL 6");
        }
    }

    protected void disposeImpl() {
    }

    public static void main(String[] args) throws Exception {
        if (!SkypeImpl.isInstalled()) {
            throw new RuntimeException("Skype not installed.");
        }
        if (!SkypeImpl.isRunning()) {
            throw new RuntimeException("Skype is not running.");
        }
        SkypeImpl.chat("no32717223").send("TEST");
    }

    private static class Holder {
        static final TestConnector instance = new TestConnector();

        private Holder() {
        }
    }
}

