/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.test;

import com.skype.connector.ConnectorUtils;
import com.skype.connector.test.Player;
import com.skype.connector.test.PlayerMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public final class CSVPlayer
extends Player {
    private final File file;
    private BufferedReader reader;

    public CSVPlayer(String filePath) throws IOException {
        this(new File(filePath));
    }

    public CSVPlayer(File file) throws IOException {
        ConnectorUtils.checkNotNull("file", file);
        this.file = file;
    }

    protected void init() {
        if (this.reader != null) {
            this.destory();
        }
        try {
            this.reader = new BufferedReader(new FileReader(this.file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("The CSV file is not found.", e);
        }
    }

    protected boolean hasNextMessage() {
        try {
            return this.reader.ready();
        }
        catch (IOException e) {
            return false;
        }
    }

    protected PlayerMessage getNextMessage() {
        String line = null;
        try {
            line = this.reader.readLine();
            String type = line.substring(0, line.indexOf(44));
            line = line.substring(line.indexOf(44) + 1);
            long time = Long.parseLong(line.substring(0, line.indexOf(44)));
            String message = line = line.substring(line.indexOf(44) + 1);
            if (type.equals("sent")) {
                return new PlayerMessage(PlayerMessage.Type.SENT, time, message);
            }
            return new PlayerMessage(PlayerMessage.Type.RECEIVED, time, message);
        }
        catch (Exception e) {
            throw new IllegalStateException("A message couldn't be taken from the line (=\"" + line + "\").", e);
        }
    }

    protected void destory() {
        if (this.reader != null) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

