/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.linux;

import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.linux.SkypeFramework;
import com.skype.connector.linux.SkypeFrameworkListener;
import java.io.File;
import java.util.concurrent.LinkedBlockingQueue;

public final class LinuxConnector
extends Connector {
    private static LinuxConnector _instance = null;
    private SkypeFrameworkListener listener = new SkypeFrameworkListener(){

        public void notificationReceived(String notificationString) {
            LinuxConnector.this.fireMessageReceived(notificationString);
        }
    };

    public static synchronized Connector getInstance() {
        if (_instance == null) {
            _instance = new LinuxConnector();
        }
        return _instance;
    }

    private LinuxConnector() {
    }

    public boolean isRunning() throws ConnectorException {
        SkypeFramework.init();
        return SkypeFramework.isRunning();
    }

    public String getInstalledPath() {
        File application = new File("/usr/bin/skype");
        if (application.exists()) {
            return application.getAbsolutePath();
        }
        return null;
    }

    protected void initializeImpl() throws ConnectorException {
        SkypeFramework.init();
        SkypeFramework.addSkypeFrameworkListener(this.listener);
    }

    protected Connector.Status connect(int timeout) throws ConnectorException {
        if (!SkypeFramework.isRunning()) {
            this.setStatus(Connector.Status.NOT_RUNNING);
            return this.getStatus();
        }
        try {
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            SkypeFrameworkListener initListener = new SkypeFrameworkListener(){

                public void notificationReceived(String notification) {
                    if ("OK".equals(notification) || "CONNSTATUS OFFLINE".equals(notification) || "ERROR 68".equals(notification)) {
                        try {
                            queue.put(notification);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            };
            this.setStatus(Connector.Status.PENDING_AUTHORIZATION);
            SkypeFramework.addSkypeFrameworkListener(initListener);
            SkypeFramework.sendCommand("NAME " + this.getApplicationName());
            String result = (String)queue.take();
            SkypeFramework.removeSkypeFrameworkListener(initListener);
            if ("OK".equals(result)) {
                this.setStatus(Connector.Status.ATTACHED);
            } else if ("CONNSTATUS OFFLINE".equals(result)) {
                this.setStatus(Connector.Status.NOT_AVAILABLE);
            } else if ("ERROR 68".equals(result)) {
                this.setStatus(Connector.Status.REFUSED);
            }
            return this.getStatus();
        }
        catch (InterruptedException e) {
            throw new ConnectorException("Trying to connect was interrupted.", e);
        }
    }

    protected void sendCommand(String command) {
        SkypeFramework.sendCommand(command);
    }

    protected void disposeImpl() {
        SkypeFramework.removeSkypeFrameworkListener(this.listener);
        SkypeFramework.dispose();
    }
}

