/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector;

import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import com.skype.connector.ConnectorStatusEvent;
import com.skype.connector.ConnectorUtils;
import com.skype.connector.MessageProcessor;
import com.skype.connector.NotAttachedException;
import com.skype.connector.NotificationChecker;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Connector {
    private static boolean _useJNIConnector;
    private static Connector _instance;
    private final Object _debugListenerMutex = new Object();
    private ConnectorListener _debugListener;
    private volatile PrintWriter _debugOut = new PrintWriter(System.out, true);
    private volatile String _applicationName = "Skype4Java";
    private volatile Status _status = Status.NOT_RUNNING;
    private volatile int _connectTimeout = 10000;
    private volatile int _commandTimeout = 10000;
    private final Object _isInitializedMutex = new Object();
    private boolean _isInitialized;
    private ExecutorService _asyncSender;
    private ExecutorService _syncSender;
    private final List<ConnectorListener> _asyncListeners = new CopyOnWriteArrayList<ConnectorListener>();
    private final List<ConnectorListener> _syncListeners = new CopyOnWriteArrayList<ConnectorListener>();
    private final AtomicInteger _commandCount = new AtomicInteger();
    private ExecutorService _commandExecutor;
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();

    public static synchronized void useJNIConnector(boolean on) {
        if (_instance != null) {
            throw new IllegalStateException("You should call Connector#useJNIConnector(boolean) before calling Connector#getInstance().");
        }
        _useJNIConnector = on;
    }

    public static synchronized Connector getInstance() {
        if (_instance == null) {
            String connectorClassName = null;
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                if (!Connector.isSWTAvailable()) {
                    _useJNIConnector = true;
                }
                connectorClassName = _useJNIConnector ? "com.skype.connector.win32.Win32Connector" : "com.skype.connector.windows.WindowsConnector";
            } else if (osName.startsWith("Linux") || osName.startsWith("LINUX")) {
                connectorClassName = "com.skype.connector.linux.LinuxConnector";
            } else if (osName.startsWith("Mac OS X")) {
                connectorClassName = "com.skype.connector.osx.OSXConnector";
            }
            if (connectorClassName == null) {
                throw new IllegalStateException("This platform is not supported by Skype4Java.");
            }
            try {
                Class<?> connectorClass = Class.forName(connectorClassName);
                Method getInstance = connectorClass.getMethod("getInstance", new Class[0]);
                _instance = (Connector)getInstance.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("The connector couldn't be initialized.", e);
            }
        }
        return _instance;
    }

    private static boolean isSWTAvailable() {
        try {
            Class.forName("org.eclipse.swt.SWT");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    protected static synchronized void setInstance(Connector newInstance) throws ConnectorException {
        if (_instance != null) {
            _instance.dispose();
        }
        _instance = newInstance;
    }

    protected Connector() {
    }

    public String getInstalledPath() {
        return "skype";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDebug(boolean on) throws ConnectorException {
        Object object = this._debugListenerMutex;
        synchronized (object) {
            if (on) {
                if (this._debugListener == null) {
                    this._debugListener = new AbstractConnectorListener(){

                        public void messageReceived(ConnectorMessageEvent event) {
                            Connector.this.getDebugOut().println("<- " + event.getMessage());
                        }

                        public void messageSent(ConnectorMessageEvent event) {
                            Connector.this.getDebugOut().println("-> " + event.getMessage());
                        }
                    };
                    this.addConnectorListener(this._debugListener, true, true);
                }
            } else if (this._debugListener != null) {
                this.removeConnectorListener(this._debugListener);
                this._debugListener = null;
            }
        }
    }

    public final void setDebugOut(PrintWriter newDebugOut) {
        ConnectorUtils.checkNotNull("debugOut", newDebugOut);
        this._debugOut = newDebugOut;
    }

    public final void setDebugOut(PrintStream newDebugOut) {
        ConnectorUtils.checkNotNull("debugOut", newDebugOut);
        this.setDebugOut(new PrintWriter(newDebugOut, true));
    }

    public final PrintWriter getDebugOut() {
        return this._debugOut;
    }

    public final void setApplicationName(String newApplicationName) {
        ConnectorUtils.checkNotNull("applicationName", newApplicationName);
        this._applicationName = newApplicationName;
    }

    public final String getApplicationName() {
        return this._applicationName;
    }

    protected final void setStatus(Status newStatus) {
        ConnectorUtils.checkNotNull("status", (Object)newStatus);
        this._status = newStatus;
        this.fireStatusChanged(newStatus);
    }

    private void fireStatusChanged(final Status newStatus) {
        this._syncSender.execute(new Runnable(){

            public void run() {
                Connector.this.fireStatusChanged(Connector.this.toConnectorListenerArray(Connector.this._syncListeners), newStatus);
            }
        });
        this._asyncSender.execute(new Runnable(){

            public void run() {
                Connector.this.fireStatusChanged(Connector.this.toConnectorListenerArray(Connector.this._asyncListeners), newStatus);
            }
        });
    }

    private ConnectorListener[] toConnectorListenerArray(List<ConnectorListener> listeners) {
        return listeners.toArray(new ConnectorListener[0]);
    }

    private void fireStatusChanged(ConnectorListener[] listeners, Status newStatus) {
        ConnectorStatusEvent event = new ConnectorStatusEvent(this, newStatus);
        for (int i = listeners.length - 1; 0 <= i; --i) {
            listeners[i].statusChanged(event);
        }
    }

    public final Status getStatus() {
        return this._status;
    }

    public final void setConnectTimeout(int newConnectTimeout) {
        if (newConnectTimeout < 0) {
            throw new IllegalArgumentException("The connect timeout must be more than 0.");
        }
        this._connectTimeout = newConnectTimeout;
    }

    public final int getConnectTimeout() {
        return this._connectTimeout;
    }

    public final void setCommandTimeout(int newCommandTimeout) {
        if (newCommandTimeout < 0) {
            throw new IllegalArgumentException("The connect timeout must be more than 0.");
        }
        this._commandTimeout = newCommandTimeout;
    }

    public final int getCommandTimeout() {
        return this._commandTimeout;
    }

    public final Status connect() throws ConnectorException {
        this.initialize();
        Status status = this.connect(this.getConnectTimeout());
        if (status == Status.ATTACHED) {
            this.sendApplicationName(this.getApplicationName());
            this.sendProtocol();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initialize() throws ConnectorException {
        Object object = this._isInitializedMutex;
        synchronized (object) {
            if (!this._isInitialized) {
                this._asyncSender = Executors.newCachedThreadPool(new ThreadFactory(){
                    private final AtomicInteger threadNumber = new AtomicInteger();

                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r, "AsyncSkypeMessageSender-" + this.threadNumber.getAndIncrement());
                        thread.setDaemon(true);
                        return thread;
                    }
                });
                this._syncSender = Executors.newSingleThreadExecutor(new ThreadFactory(){

                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r, "SyncSkypeMessageSender");
                        thread.setDaemon(true);
                        return thread;
                    }
                });
                this._commandExecutor = Executors.newCachedThreadPool(new ThreadFactory(){
                    private final AtomicInteger threadNumber = new AtomicInteger();

                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r, "CommandExecutor-" + this.threadNumber.getAndIncrement());
                        thread.setDaemon(true);
                        return thread;
                    }
                });
                this.initializeImpl();
                this._isInitialized = true;
            }
        }
    }

    protected abstract void initializeImpl() throws ConnectorException;

    protected abstract Status connect(int var1) throws ConnectorException;

    protected void sendApplicationName(String applicationName) throws ConnectorException {
    }

    protected void sendProtocol() throws ConnectorException {
        this.execute("PROTOCOL 9999", new String[]{"PROTOCOL "}, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() throws ConnectorException {
        Object object = this._isInitializedMutex;
        synchronized (object) {
            if (!this._isInitialized) {
                return;
            }
            this.disposeImpl();
            this.setStatus(Status.NOT_RUNNING);
            this._commandExecutor.shutdown();
            this._syncSender.shutdown();
            this._asyncSender.shutdown();
            this._syncListeners.clear();
            this._asyncListeners.clear();
            Object object2 = this._debugListenerMutex;
            synchronized (object2) {
                if (this._debugListener != null) {
                    this.addConnectorListener(this._debugListener, false, true);
                }
            }
            this._isInitialized = false;
        }
    }

    protected abstract void disposeImpl() throws ConnectorException;

    public boolean isRunning() throws ConnectorException {
        try {
            this.assureAttached();
            return true;
        }
        catch (ConnectorException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void execute(String command, final MessageProcessor processor) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        ConnectorUtils.checkNotNull("processor", processor);
        this.assureAttached();
        Object wait = new Object();
        AbstractConnectorListener listener = new AbstractConnectorListener(){

            public void messageReceived(ConnectorMessageEvent event) {
                processor.messageReceived(event.getMessage());
            }
        };
        processor.init(wait, listener);
        this.addConnectorListener(listener, false);
        Object object = wait;
        synchronized (object) {
            try {
                this.fireMessageSent(command);
                this.sendCommand(command);
                long start = System.currentTimeMillis();
                long commandResponseTime = this.getCommandTimeout();
                wait.wait(commandResponseTime);
                if (commandResponseTime <= System.currentTimeMillis() - start) {
                    this.setStatus(Status.NOT_RUNNING);
                    throw new NotAttachedException(Status.NOT_RUNNING);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ConnectorException("The '" + command + "' command was interrupted.", e);
            }
            finally {
                this.removeConnectorListener(listener);
            }
        }
    }

    public final String execute(String command) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        return this.execute(command, command);
    }

    public final String executeWithId(String command, String responseHeader) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        ConnectorUtils.checkNotNull("responseHeader", responseHeader);
        String header = "#" + this._commandCount.getAndIncrement() + " ";
        String response = this.execute(header + command, new String[]{header + responseHeader, header + "ERROR "}, true);
        return response.substring(header.length());
    }

    public final Future waitForEndWithId(String command, String responseHeader, final NotificationChecker checker) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        ConnectorUtils.checkNotNull("responseHeader", responseHeader);
        ConnectorUtils.checkNotNull("responseHeader", checker);
        final String header = "#" + this._commandCount.getAndIncrement() + " ";
        NotificationChecker wrappedChecker = new NotificationChecker(){

            public boolean isTarget(String message) {
                if (checker.isTarget(message)) {
                    return true;
                }
                return message.startsWith(header + "ERROR ");
            }
        };
        final Future<String> future = this.execute(header + command, wrappedChecker, true, false);
        return new Future<String>(){

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public String get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.removeId((String)future.get(timeout, unit));
            }

            @Override
            public String get() throws InterruptedException, ExecutionException {
                return this.removeId((String)future.get());
            }

            private String removeId(String message) {
                if (message.startsWith(header)) {
                    return message.substring(header.length());
                }
                return message;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }
        };
    }

    public final String executeWithoutTimeout(String command, String responseHeader) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        ConnectorUtils.checkNotNull("responseHeader", responseHeader);
        return this.execute(command, new String[]{responseHeader, "ERROR "}, true, true);
    }

    public final String execute(String command, String responseHeader) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        ConnectorUtils.checkNotNull("responseHeader", responseHeader);
        return this.execute(command, new String[]{responseHeader, "ERROR "}, true);
    }

    public final String execute(String command, String[] responseHeaders) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        ConnectorUtils.checkNotNull("responseHeaders", responseHeaders);
        return this.execute(command, responseHeaders, true);
    }

    protected final String execute(String command, String[] responseHeaders, boolean checkAttached) throws ConnectorException {
        return this.execute(command, responseHeaders, checkAttached, false);
    }

    private String execute(String command, final String[] responseHeaders, boolean checkAttached, boolean withoutTimeout) throws ConnectorException {
        NotificationChecker checker = new NotificationChecker(){

            public boolean isTarget(String message) {
                for (String responseHeader : responseHeaders) {
                    if (!message.startsWith(responseHeader)) continue;
                    return true;
                }
                return false;
            }
        };
        try {
            return this.execute(command, checker, checkAttached, withoutTimeout).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConnectorException("The '" + command + "' command was interrupted.", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NotAttachedException) {
                NotAttachedException cause = (NotAttachedException)e.getCause();
                throw new NotAttachedException(cause.getStatus(), (Throwable)cause);
            }
            if (e.getCause() instanceof ConnectorException) {
                ConnectorException cause = (ConnectorException)e.getCause();
                throw new ConnectorException(cause.getMessage(), cause);
            }
            throw new ConnectorException("The '" + command + "' command execution failed.", e);
        }
    }

    private Future<String> execute(final String command, final NotificationChecker responseChecker, boolean checkAttached, boolean withoutTimeout) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        ConnectorUtils.checkNotNull("responseChecker", responseChecker);
        if (checkAttached) {
            this.assureAttached();
        }
        return this._commandExecutor.submit(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                final LinkedBlockingQueue responses = new LinkedBlockingQueue();
                AbstractConnectorListener listener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent event) {
                        String message = event.getMessage();
                        if (responseChecker.isTarget(message) || message.startsWith("PONG")) {
                            responses.add(message);
                        }
                    }
                };
                Connector.this.addConnectorListener(listener, false);
                Connector.this.fireMessageSent(command);
                Connector.this.sendCommand(command);
                try {
                    String response;
                    boolean pinged = false;
                    while (true) {
                        if ((response = (String)responses.poll(Connector.this.getCommandTimeout(), TimeUnit.MILLISECONDS)) == null) {
                            if (pinged) {
                                Connector.this.setStatus(Status.NOT_RUNNING);
                                throw new NotAttachedException(Status.NOT_RUNNING);
                            }
                            Connector.this.fireMessageSent("PING");
                            Connector.this.sendCommand("PING");
                            pinged = true;
                            continue;
                        }
                        if (!response.startsWith("PONG")) break;
                        pinged = false;
                    }
                    String string = response;
                    return string;
                }
                finally {
                    Connector.this.removeConnectorListener(listener);
                }
            }
        });
    }

    private void fireMessageSent(String message) {
        this.fireMessageEvent(message, false);
    }

    protected abstract void sendCommand(String var1);

    private void assureAttached() throws ConnectorException {
        Status attachedStatus = this.getStatus();
        if (attachedStatus != Status.ATTACHED && (attachedStatus = this.connect()) != Status.ATTACHED) {
            throw new NotAttachedException(attachedStatus);
        }
    }

    public final void addConnectorListener(ConnectorListener listener) throws ConnectorException {
        this.addConnectorListener(listener, true);
    }

    public final void addConnectorListener(ConnectorListener listener, boolean checkAttached) throws ConnectorException {
        this.addConnectorListener(listener, checkAttached, false);
    }

    public final void addConnectorListener(ConnectorListener listener, boolean checkAttached, boolean isSynchronous) throws ConnectorException {
        ConnectorUtils.checkNotNull("listener", listener);
        if (isSynchronous) {
            this._syncListeners.add(listener);
        } else {
            this._asyncListeners.add(listener);
        }
        if (checkAttached) {
            this.assureAttached();
        }
    }

    public final void removeConnectorListener(ConnectorListener listener) {
        ConnectorUtils.checkNotNull("listener", listener);
        this._syncListeners.remove(listener);
        this._asyncListeners.remove(listener);
    }

    protected final void fireMessageReceived(String message) {
        this.fireMessageEvent(message, true);
    }

    private void fireMessageEvent(final String message, final boolean isReceived) {
        ConnectorUtils.checkNotNull("message", message);
        this._syncSender.execute(new Runnable(){

            public void run() {
                Connector.this.fireMessageEvent(Connector.this.toConnectorListenerArray(Connector.this._syncListeners), message, isReceived);
            }
        });
        this._asyncSender.execute(new Runnable(){

            public void run() {
                Connector.this.fireMessageEvent(Connector.this.toConnectorListenerArray(Connector.this._asyncListeners), message, isReceived);
            }
        });
    }

    private void fireMessageEvent(ConnectorListener[] listeners, String message, boolean isReceived) {
        ConnectorMessageEvent event = new ConnectorMessageEvent(this, message);
        for (int i = listeners.length - 1; 0 <= i; --i) {
            if (isReceived) {
                listeners[i].messageReceived(event);
                continue;
            }
            listeners[i].messageSent(event);
        }
    }

    public final void setStringProperty(String name, String value) {
        ConnectorUtils.checkNotNull("name", name);
        if (value != null) {
            this.properties.put(name, value);
        } else {
            this.properties.remove(name);
        }
    }

    public final String getStringProperty(String name) {
        ConnectorUtils.checkNotNull("name", name);
        return this.properties.get(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PENDING_AUTHORIZATION,
        ATTACHED,
        REFUSED,
        NOT_AVAILABLE,
        API_AVAILABLE,
        NOT_RUNNING;

    }
}

