/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.SkypeException;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;

public final class Profile {
    public static final String STATUS_PROPERTY = "status";
    public static final String MOOD_TEXT_PROPERTY = "moodText";
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Object propertyChangeListenerMutex = new Object();
    private ConnectorListener propertyChangeListener;

    Profile() {
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getProperty("USERSTATUS"));
    }

    public void setStatus(Status newValue) throws SkypeException {
        Utils.checkNotNull("newValue", (Object)newValue);
        Utils.setProperty("USERSTATUS", newValue.toString());
    }

    public String getId() throws SkypeException {
        return Utils.getProperty("CURRENTUSERHANDLE");
    }

    public boolean canDoSkypeOut() throws SkypeException {
        return this.canDo("SKYPEOUT");
    }

    public boolean canDoSkypeIn() throws SkypeException {
        return this.canDo("SKYPEIN");
    }

    public boolean canDoVoiceMail() throws SkypeException {
        return this.canDo("VOICEMAIL");
    }

    private boolean canDo(String name) throws SkypeException {
        return Boolean.parseBoolean(Utils.getProperty("PRIVILEGE", name));
    }

    @Deprecated
    public int getPSTNBalance() throws SkypeException {
        return Integer.parseInt(this.getProperty("PSTN_BALANCE"));
    }

    public int getCredit() throws SkypeException {
        return this.getPSTNBalance();
    }

    @Deprecated
    public String getPSTNBalanceCurrencyUnit() throws SkypeException {
        return this.getProperty("PSTN_BALANCE_CURRENCY");
    }

    public String getCreditCurrencyUnit() throws SkypeException {
        return this.getPSTNBalanceCurrencyUnit();
    }

    public String getFullName() throws SkypeException {
        return this.getProperty("FULLNAME");
    }

    public void setFullName(String newValue) throws SkypeException {
        this.setProperty("FULLNAME", newValue);
    }

    public Date getBirthDay() throws SkypeException {
        String value = this.getProperty("BIRTHDAY");
        if ("0".equals(value)) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyyMMdd").parse(value);
        }
        catch (ParseException e) {
            throw new IllegalStateException("The library developer should check Skype specification.");
        }
    }

    public void setBirthDay(Date newValue) throws SkypeException {
        String newValueString = newValue == null ? "0" : new SimpleDateFormat("yyyyMMdd").format(newValue);
        this.setProperty("BIRTHDAY", newValueString);
    }

    public Sex getSex() throws SkypeException {
        return Sex.valueOf(this.getProperty("SEX"));
    }

    public void setSex(Sex newValue) throws SkypeException {
        Utils.checkNotNull("newValue", (Object)newValue);
        this.setProperty("SEX", newValue.toString());
    }

    @Deprecated
    public String[] getAllLauguages() throws SkypeException {
        return this.getProperty("LANGUAGES").split(" ");
    }

    public String getLanguageByISOCode() throws SkypeException {
        return this.getAllLauguages()[0];
    }

    @Deprecated
    public void setAllLanguages(String[] newValues) throws SkypeException {
        if (newValues == null) {
            newValues = new String[]{};
        }
        this.setProperty("LANGUAGES", this.toSpaceSeparatedString(newValues));
    }

    public void setLanguageByISOCode(String newValue) throws SkypeException {
        this.setProperty("LANGUAGES", newValue);
    }

    private String toSpaceSeparatedString(Object[] newValues) {
        StringBuilder newValuesString = new StringBuilder();
        for (int i = 0; i < newValues.length; ++i) {
            if (i != 0) {
                newValuesString.append(' ');
            }
            newValuesString.append(newValues[i]);
        }
        return newValuesString.toString();
    }

    public String getCountryByISOCode() throws SkypeException {
        String value = this.getProperty("COUNTRY");
        return value.substring(0, value.indexOf(32));
    }

    public String getIPCountryByISOCode() throws SkypeException {
        return this.getProperty("IPCOUNTRY");
    }

    public void setCountryByISOCode(String newValue) throws SkypeException {
        this.setProperty("COUNTRY", Utils.convertNullToEmptyString(newValue) + " " + this.getCountry());
    }

    public String getCountry() throws SkypeException {
        String value = this.getProperty("COUNTRY");
        return value.substring(value.indexOf(32) + 1);
    }

    public void setCountry(String newValue) throws SkypeException {
        this.setProperty("COUNTRY", this.getCountryByISOCode() + " " + Utils.convertNullToEmptyString(newValue));
    }

    public String getProvince() throws SkypeException {
        return this.getProperty("PROVINCE");
    }

    public void setProvince(String newValue) throws SkypeException {
        this.setProperty("PROVINCE", newValue);
    }

    public String getCity() throws SkypeException {
        return this.getProperty("CITY");
    }

    public void setCity(String newValue) throws SkypeException {
        this.setProperty("CITY", newValue);
    }

    public String getHomePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_HOME");
    }

    public void setHomePhoneNumber(String newValue) throws SkypeException {
        this.setProperty("PHONE_HOME", newValue);
    }

    public String getOfficePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_OFFICE");
    }

    public void setOfficePhoneNumber(String newValue) throws SkypeException {
        this.setProperty("PHONE_OFFICE", newValue);
    }

    public String getMobilePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_MOBILE");
    }

    public void setMobilePhoneNumber(String newValue) throws SkypeException {
        this.setProperty("PHONE_MOBILE", newValue);
    }

    @Deprecated
    public String getHomePageAddress() throws SkypeException {
        return this.getProperty("HOMEPAGE");
    }

    public String getWebSiteAddress() throws SkypeException {
        return this.getHomePageAddress();
    }

    @Deprecated
    public void setHomePageAddress(String newValue) throws SkypeException {
        this.setProperty("HOMEPAGE", newValue);
    }

    public void setWebSiteAddress(String newValue) throws SkypeException {
        this.setHomePageAddress(newValue);
    }

    public String getIntroduction() throws SkypeException {
        return this.getProperty("ABOUT");
    }

    public void setIntroduction(String newValue) throws SkypeException {
        this.setProperty("ABOUT", newValue);
    }

    public String getMoodMessage() throws SkypeException {
        return this.getProperty("MOOD_TEXT");
    }

    public void setMoodMessage(String newValue) throws SkypeException {
        this.setProperty("MOOD_TEXT", newValue);
    }

    public String getRichMoodMessage() throws SkypeException {
        return this.getProperty("RICH_MOOD_TEXT");
    }

    public void setRichMoodMessage(String newValue) throws SkypeException {
        this.setProperty("RICH_MOOD_TEXT", newValue);
    }

    public void setAvatar(BufferedImage newValue) throws SkypeException {
        if (newValue == null) {
            this.setAvatarByFile(null);
            return;
        }
        try {
            File file = Utils.createTempraryFile("set_avator_", "jpg");
            if (ImageIO.write((RenderedImage)newValue, "jpg", file)) {
                this.setAvatarByFile(file);
                file.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setAvatarByFile(File newValue) throws SkypeException {
        String newValueString = newValue == null ? "" : newValue.getAbsolutePath();
        Utils.setProperty("AVATAR", "1", newValueString);
    }

    public BufferedImage getAvatar() throws SkypeException {
        try {
            File file = Utils.createTempraryFile("get_avator_", "jpg");
            String command = "GET AVATAR 1 " + file.getAbsolutePath();
            String responseHeader = "AVATAR 1 ";
            String response = Connector.getInstance().execute(command, "AVATAR 1 ");
            Utils.checkError(response);
            BufferedImage image = ImageIO.read(file);
            file.delete();
            return image;
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public int getTimeZone() throws SkypeException {
        return Integer.parseInt(this.getProperty("TIMEZONE"));
    }

    public void setTimeZone(int newValue) throws SkypeException {
        this.setProperty("TIMEZONE", "" + newValue);
    }

    public boolean isVideoCapable() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_VIDEO_CAPABLE"));
    }

    public int getWaitTimeBeforeCallForwarding() throws SkypeException {
        return Integer.parseInt(this.getProperty("CALL_NOANSWER_TIMEOUT"));
    }

    public void setWaitTimeBeforeCallForwarding(int newValue) throws SkypeException {
        this.setProperty("CALL_NOANSWER_TIMEOUT", "" + newValue);
    }

    public boolean isCallForwarding() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("CALL_APPLY_CF"));
    }

    public void setCallForwarding(boolean on) throws SkypeException {
        this.setProperty("CALL_APPLY_CF", ("" + on).toUpperCase());
    }

    public CallForwardingRule[] getAllCallForwardingRules() throws SkypeException {
        ArrayList<CallForwardingRule> rules = new ArrayList<CallForwardingRule>();
        String value = this.getProperty("CALL_FORWARD_RULES");
        if ("".equals(value)) {
            return new CallForwardingRule[0];
        }
        for (String rule : value.split(" ")) {
            String[] elements = rule.split(",");
            rules.add(new CallForwardingRule(Integer.parseInt(elements[0]), Integer.parseInt(elements[1]), elements[2]));
        }
        return rules.toArray(new CallForwardingRule[0]);
    }

    public void setAllCallForwardingRules(CallForwardingRule[] newValues) throws SkypeException {
        if (newValues == null) {
            newValues = new CallForwardingRule[]{};
        }
        this.setProperty("CALL_FORWARD_RULES", this.toSpaceSeparatedString(newValues));
    }

    public String[] getAllValidSMSNumbers() throws SkypeException {
        return Utils.convertToArray(this.getProperty("SMS_VALIDATED_NUMBERS"));
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("PROFILE", name);
    }

    private void setProperty(String name, String value) throws SkypeException {
        Utils.setProperty("PROFILE", name, Utils.convertNullToEmptyString(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener listener) throws SkypeException {
        Object object = this.propertyChangeListenerMutex;
        synchronized (object) {
            if (this.propertyChangeListener == null) {
                AbstractConnectorListener connectorListener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent event) {
                        String message = event.getMessage();
                        if (message.startsWith("PROFILE ")) {
                            String data = message.substring("PROFILE ".length());
                            String propertyName = data.substring(0, data.indexOf(32));
                            String propertyValue = data.substring(data.indexOf(32) + 1);
                            if (propertyName.equals("MOOD_TEXT")) {
                                Profile.this.firePropertyChanged(Profile.MOOD_TEXT_PROPERTY, null, propertyValue);
                            }
                        } else if (message.startsWith("USERSTATUS ")) {
                            String value = message.substring("USERSTATUS ".length());
                            Profile.this.firePropertyChanged(Profile.STATUS_PROPERTY, null, (Object)Status.valueOf(value));
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(connectorListener);
                    this.propertyChangeListener = connectorListener;
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
        }
        this.listeners.addPropertyChangeListener(listener);
    }

    private void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propertyName, oldValue, newValue);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public static final class CallForwardingRule {
        private final int startSecond;
        private final int endSecond;
        private final String target;

        public CallForwardingRule(int newStartSecond, int newEndSecond, String newTarget) {
            this.startSecond = newStartSecond;
            this.endSecond = newEndSecond;
            if (newTarget.startsWith("+")) {
                newTarget = newTarget.replaceAll("-", "");
            }
            this.target = newTarget;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object compared) {
            if (compared instanceof CallForwardingRule) {
                return this.toString().equals(((CallForwardingRule)compared).toString());
            }
            return false;
        }

        public String toString() {
            return this.startSecond + "," + this.endSecond + "," + this.target;
        }

        public int getStartSecond() {
            return this.startSecond;
        }

        public int getEndSecond() {
            return this.endSecond;
        }

        public String getTarget() {
            return this.target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sex {
        UNKNOWN,
        MALE,
        FEMALE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        ONLINE,
        OFFLINE,
        SKYPEME,
        AWAY,
        NA,
        DND,
        INVISIBLE,
        LOGGEDOUT;

    }
}

