/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.MenuItemClickEvent;
import com.skype.MenuItemListener;
import com.skype.SkypeException;
import com.skype.SkypeImpl;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class MenuItem {
    private static final Map<String, MenuItem> menuItems = new ConcurrentHashMap<String, MenuItem>();
    private static final AtomicInteger menuItemNumber = new AtomicInteger();
    private static final Object menuItemListenerMutex = new Object();
    private static ConnectorListener menuItemListener;
    private final String id = "menuItem" + menuItemNumber.getAndIncrement();
    private final Context context;
    private String caption;
    private String hint;
    private final File iconFile;
    private boolean enabled;
    private final String targetSkypeId;
    private final boolean multipleContactsEnabled;
    private final List<MenuItemListener> menuItemListeners = new CopyOnWriteArrayList<MenuItemListener>();

    static MenuItem getInstance(String id) {
        return menuItems.get(id);
    }

    static MenuItem addMenuItem(Context context, String caption, String hint, File iconFile, boolean enabled, String targetSkypeId, boolean multipleContactsEnabled) {
        MenuItem menuItem = new MenuItem(context, caption, hint, iconFile, enabled, targetSkypeId, multipleContactsEnabled);
        menuItems.put(menuItem.getId(), menuItem);
        return menuItem;
    }

    MenuItem(Context context, String caption, String hint, File iconFile, boolean enabled, String targetSkypeId, boolean multipleContactsEnabled) {
        this.context = context;
        this.caption = caption;
        this.hint = hint;
        this.iconFile = iconFile;
        this.enabled = enabled;
        this.targetSkypeId = targetSkypeId;
        this.multipleContactsEnabled = multipleContactsEnabled;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object compared) {
        if (compared instanceof MenuItem) {
            return this.getId().equals(((MenuItem)compared).getId());
        }
        return false;
    }

    String getId() {
        return this.id;
    }

    public Context getContext() {
        return this.context;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) throws SkypeException {
        Utils.checkNotNull("caption", caption);
        this.caption = caption;
        this.setStringProperty("CAPTION", caption);
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) throws SkypeException {
        this.hint = hint;
        if (hint == null) {
            hint = "";
        }
        this.setStringProperty("HINT", hint);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) throws SkypeException {
        this.enabled = enabled;
        this.setProperty("ENABLED", "" + enabled);
    }

    private void setStringProperty(String name, String value) throws SkypeException {
        this.setProperty(name, "\"" + value + "\"");
    }

    private void setProperty(String name, String value) throws SkypeException {
        Utils.setProperty("MENU_ITEM", this.getId(), name, value);
    }

    public File getIconFile() {
        return this.iconFile;
    }

    public boolean isMultipleContactsEnabled() {
        return this.multipleContactsEnabled;
    }

    public String getTargetSkypeId() {
        return this.targetSkypeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMenuItemListener(MenuItemListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        this.menuItemListeners.add(listener);
        Object object = menuItemListenerMutex;
        synchronized (object) {
            if (menuItemListener == null) {
                menuItemListener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent event) {
                        String message = event.getMessage();
                        if (message.startsWith("MENU_ITEM ") && message.indexOf(" CLICKED ") != -1) {
                            Context context;
                            String notParsed = message.substring("MENU_ITEM ".length());
                            int clickedIndex = notParsed.indexOf(" CLICKED ");
                            String id = notParsed.substring(0, clickedIndex);
                            notParsed = notParsed.substring(clickedIndex + " CLICKED ".length());
                            int contextIndex = notParsed.indexOf("CONTEXT ");
                            String[] skypeIds = Utils.convertToArray(notParsed.substring(0, contextIndex));
                            notParsed = notParsed.substring(contextIndex + "CONTEXT ".length());
                            int spaceIndex = notParsed.indexOf(32);
                            String[] contextIds = new String[]{};
                            if (spaceIndex == -1) {
                                context = Context.valueOf(notParsed.toUpperCase());
                            } else {
                                context = Context.valueOf(notParsed.substring(0, spaceIndex));
                                notParsed = notParsed.substring(spaceIndex + 1);
                                contextIds = Utils.convertToArray(notParsed.substring("CONTEXT_ID ".length()));
                            }
                            MenuItem menuItem = MenuItem.getInstance(id);
                            if (menuItem != null) {
                                MenuItemListener[] listeners;
                                for (MenuItemListener listener : listeners = menuItem.menuItemListeners.toArray(new MenuItemListener[0])) {
                                    try {
                                        listener.menuItemClicked(new MenuItemClickEvent(MenuItem.this, skypeIds, context, contextIds));
                                    }
                                    catch (Throwable e) {
                                        SkypeImpl.handleUncaughtException(e);
                                    }
                                }
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(menuItemListener);
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMenuItemListener(MenuItemListener listener) {
        Utils.checkNotNull("listener", listener);
        this.menuItemListeners.remove(listener);
        Object object = menuItemListenerMutex;
        synchronized (object) {
            boolean isEmpty = true;
            for (MenuItem menuItem : menuItems.values()) {
                isEmpty &= menuItem.menuItemListeners.isEmpty();
            }
            if (isEmpty) {
                Connector.getInstance().removeConnectorListener(menuItemListener);
                menuItemListener = null;
            }
        }
    }

    public void dispose() throws SkypeException {
        try {
            String command = "DELETE MENU_ITEM " + this.getId();
            String response = Connector.getInstance().execute(command);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Context {
        CHAT,
        CALL,
        CONTACT,
        MYSELF,
        TOOLS;

    }
}

