/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.EventMessageListener;
import com.skype.SkypeException;
import com.skype.SkypeImpl;
import com.skype.SkypeObject;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class EventMessage
extends SkypeObject {
    private static final Map<String, EventMessage> eventMessages = Collections.synchronizedMap(new HashMap());
    private static final AtomicInteger eventMessageNumber = new AtomicInteger();
    private static Object eventMessageListenerMutex = new Object();
    private static ConnectorListener eventMessageListener;
    private final String id = "eventMessage" + eventMessageNumber.getAndIncrement();
    private final String caption;
    private final String hint;
    private final List<EventMessageListener> eventMessageListeners = Collections.synchronizedList(new ArrayList());

    static EventMessage getInstance(String id) {
        return eventMessages.get(id);
    }

    static EventMessage addEventMessage(String caption, String hint) {
        EventMessage eventMessage = new EventMessage(caption, hint);
        eventMessages.put(eventMessage.getId(), eventMessage);
        return eventMessage;
    }

    EventMessage(String caption, String hint) {
        this.caption = caption;
        this.hint = hint;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object compared) {
        if (compared instanceof EventMessage) {
            return this.getId().equals(((EventMessage)compared).getId());
        }
        return false;
    }

    String getId() {
        return this.id;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getHint() {
        return this.hint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventMessageListener(EventMessageListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        this.eventMessageListeners.add(listener);
        Object object = eventMessageListenerMutex;
        synchronized (object) {
            if (eventMessageListener == null) {
                eventMessageListener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent event) {
                        String id;
                        EventMessage eventMessage;
                        String message = event.getMessage();
                        if (message.startsWith("EVENT ") && message.endsWith(" CLICKED") && (eventMessage = EventMessage.getInstance(id = message.substring("EVENT ".length(), message.length() - " CLICKED".length()))) != null) {
                            EventMessageListener[] listeners;
                            for (EventMessageListener listener : listeners = eventMessage.eventMessageListeners.toArray(new EventMessageListener[0])) {
                                try {
                                    listener.eventMessageClicked();
                                }
                                catch (Throwable e) {
                                    SkypeImpl.handleUncaughtException(e);
                                }
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(eventMessageListener);
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventMessageListener(EventMessageListener listener) {
        Utils.checkNotNull("listener", listener);
        this.eventMessageListeners.remove(listener);
        Object object = eventMessageListenerMutex;
        synchronized (object) {
            boolean isEmpty = true;
            for (EventMessage eventMessage : eventMessages.values()) {
                isEmpty &= eventMessage.eventMessageListeners.isEmpty();
            }
            if (isEmpty) {
                Connector.getInstance().removeConnectorListener(eventMessageListener);
                eventMessageListener = null;
            }
        }
    }

    public void dispose() throws SkypeException {
        try {
            String command = "DELETE EVENT " + this.getId();
            String response = Connector.getInstance().execute(command);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }
}

