/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.ApplicationListener;
import com.skype.Friend;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeImpl;
import com.skype.SkypeObject;
import com.skype.Stream;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Application
extends SkypeObject {
    private static final ConcurrentMap<String, Application> applications = new ConcurrentHashMap<String, Application>();
    private final String name;
    private boolean isInitialized;
    private final Object isInitializedFieldMutex = new Object();
    private Thread shutdownHookForFinish = new ShutdownHookForFinish();
    private final ConnectorListener dataListener = new DataListener();
    private final Object connectMutex = new Object();
    private final List<ApplicationListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, Stream> streams = new HashMap<String, Stream>();
    private SkypeExceptionHandler exceptionHandler;

    static Application getInstance(String id) throws SkypeException {
        Application newApplication = new Application(id);
        Application application = applications.putIfAbsent(id, newApplication);
        if (application == null) {
            application = newApplication;
        }
        application.initialize();
        return application;
    }

    private Application(String newName) throws SkypeException {
        assert (newName != null);
        this.name = newName;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() throws SkypeException {
        try {
            Object object = this.isInitializedFieldMutex;
            synchronized (object) {
                String response = Connector.getInstance().execute("CREATE APPLICATION " + this.name);
                this.getAllStreams();
                if (response.startsWith("ERROR ") && !response.startsWith("ERROR 541 ")) {
                    Utils.checkError(response);
                }
                if (!this.isInitialized) {
                    Connector.getInstance().addConnectorListener(this.dataListener, false, true);
                    Runtime.getRuntime().addShutdownHook(this.shutdownHookForFinish);
                    this.isInitialized = true;
                }
            }
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws SkypeException {
        try {
            Object object = this.isInitializedFieldMutex;
            synchronized (object) {
                if (this.isInitialized) {
                    Connector.getInstance().removeConnectorListener(this.dataListener);
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHookForFinish);
                    String response = Connector.getInstance().execute("DELETE APPLICATION " + this.getName());
                    Utils.checkError(response);
                    this.isInitialized = false;
                }
            }
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public Stream[] connectToAll() throws SkypeException {
        return this.connect(this.getAllConnectableFriends());
    }

    public Stream[] connect(Friend ... friends) throws SkypeException {
        Utils.checkNotNull("friends", friends);
        return this.connect(this.toIds(friends));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stream[] connect(final String ... ids) throws SkypeException {
        Utils.checkNotNull("ids", ids);
        Object object = this.connectMutex;
        synchronized (object) {
            try {
                final Stream[] wait = new Object();
                AbstractConnectorListener connectorListener = new AbstractConnectorListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void messageReceived(ConnectorMessageEvent event) {
                        String message = event.getMessage();
                        if (message.equals("APPLICATION " + Application.this.getName() + " CONNECTING ")) {
                            Object object = wait;
                            synchronized (object) {
                                wait.notify();
                            }
                        } else if (message.startsWith("APPLICATION " + Application.this.getName() + " STREAMS ")) {
                            String streamIds = message.substring(("APPLICATION " + Application.this.getName() + " STREAMS ").length());
                            if ("".equals(streamIds)) {
                                return;
                            }
                            for (String streamId : streamIds.split(" ")) {
                                for (String id : ids) {
                                    if (!streamId.startsWith(id + ":")) continue;
                                    Object object = wait;
                                    synchronized (object) {
                                        wait.notify();
                                        return;
                                    }
                                }
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(connectorListener);
                    Stream[] streamArray = wait;
                    synchronized (wait) {
                        for (String skypeId : ids) {
                            if (skypeId == null) continue;
                            String command = "ALTER APPLICATION " + this.getName() + " CONNECT " + skypeId;
                            String result = Connector.getInstance().execute(command, new String[]{command, "APPLICATION " + this.getName() + " CONNECTING ", "ERROR "});
                            Utils.checkError(result);
                        }
                        try {
                            wait.wait();
                        }
                        catch (InterruptedException e2) {
                            throw new SkypeException("The connecting was interrupted.", e2);
                        }
                        streamArray = this.getAllStreams(ids);
                        return streamArray;
                    }
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                    Stream[] e2 = null;
                    return e2;
                }
                finally {
                    Connector.getInstance().removeConnectorListener(connectorListener);
                }
            }
            catch (SkypeException e) {
                Stream[] arr$ = this.getAllStreams(ids);
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) {
                        throw e;
                    }
                    Stream stream = arr$[i$];
                    try {
                        stream.disconnect();
                    }
                    catch (SkypeException e2) {
                        // empty catch block
                    }
                    ++i$;
                }
            }
        }
    }

    public Stream[] getAllStreams(Friend ... friends) throws SkypeException {
        Utils.checkNotNull("friends", friends);
        return this.getAllStreams(this.toIds(friends));
    }

    private String[] toIds(Friend ... friends) {
        String[] ids = new String[friends.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = friends[i].getId();
        }
        return ids;
    }

    public Stream[] getAllStreams(String ... ids) throws SkypeException {
        ArrayList<Stream> results = new ArrayList<Stream>();
        for (Stream stream : this.getAllStreams()) {
            String comparedId = stream.getFriend().getId();
            for (String id : ids) {
                if (!comparedId.equals(id)) continue;
                results.add(stream);
            }
        }
        return results.toArray(new Stream[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream[] getAllStreams() throws SkypeException {
        String streamIds = Utils.getPropertyWithCommandId("APPLICATION", this.getName(), "STREAMS");
        Map<String, Stream> map = this.streams;
        synchronized (map) {
            this.fireStreamEvents(streamIds);
            if ("".equals(streamIds)) {
                return new Stream[0];
            }
            String[] ids = streamIds.split(" ");
            Stream[] results = new Stream[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                results[i] = this.streams.get(ids[i]);
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStreamEvents(String newStreamIdList) {
        Map<String, Stream> map = this.streams;
        synchronized (map) {
            String[] oldStreamIds;
            String[] newStreamIds;
            for (String streamId : newStreamIds = "".equals(newStreamIdList) ? new String[]{} : newStreamIdList.split(" ")) {
                if (this.streams.containsKey(streamId)) continue;
                Stream stream = new Stream(this, streamId);
                this.streams.put(streamId, stream);
                this.fireConnected(stream);
            }
            block4: for (String oldStreamId : oldStreamIds = this.streams.keySet().toArray(new String[0])) {
                for (String newStreamId : newStreamIds) {
                    if (oldStreamId.equals(newStreamId)) continue block4;
                }
                Stream stream = this.streams.remove(oldStreamId);
                this.fireDisconnected(stream);
            }
        }
    }

    private void fireConnected(Stream stream) {
        ApplicationListener[] myListeners;
        assert (stream != null);
        for (ApplicationListener listener : myListeners = this.listeners.toArray(new ApplicationListener[0])) {
            try {
                listener.connected(stream);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    private void fireDisconnected(Stream stream) {
        ApplicationListener[] myListeners;
        assert (stream != null);
        for (ApplicationListener listener : myListeners = this.listeners.toArray(new ApplicationListener[0])) {
            try {
                listener.disconnected(stream);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    public void addApplicationListener(ApplicationListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.add(listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.remove(listener);
    }

    public Friend[] getAllConnectableFriends() throws SkypeException {
        return this.getAllFriends("CONNECTABLE");
    }

    public Friend[] getAllConnectingFriends() throws SkypeException {
        return this.getAllFriends("CONNECTING");
    }

    public Friend[] getAllConnectedFriends() throws SkypeException {
        return this.getAllFriends("STREAMS");
    }

    public Friend[] getAllSendingFriends() throws SkypeException {
        return this.getAllFriends("SENDING");
    }

    public Friend[] getAllReceivedFriends() throws SkypeException {
        return this.getAllFriends("RECEIVED");
    }

    private Friend[] getAllFriends(String type) throws SkypeException {
        try {
            String command = "GET APPLICATION " + this.getName() + " " + type;
            String responseHeader = "APPLICATION " + this.getName() + " " + type + " ";
            String response = Connector.getInstance().executeWithId(command, responseHeader);
            Utils.checkError(response);
            return this.extractFriends(response.substring(responseHeader.length()));
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    private Friend[] extractFriends(String list) throws SkypeException {
        assert (list != null);
        if ("".equals(list)) {
            return new Friend[0];
        }
        String[] ids = list.split(" ");
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            if (!id.contains(":")) continue;
            ids[i] = id.substring(0, id.indexOf(58));
        }
        Friend[] allFriends = SkypeImpl.getContactList().getAllFriends();
        ArrayList<Friend> friends = new ArrayList<Friend>();
        for (String id : ids) {
            for (Friend friend : allFriends) {
                if (!friend.getId().equals(id)) continue;
                friends.add(friend);
            }
        }
        return friends.toArray(new Friend[0]);
    }

    private class ShutdownHookForFinish
    extends Thread {
        private ShutdownHookForFinish() {
        }

        public void run() {
            try {
                Connector.getInstance().execute("DELETE APPLICATION " + Application.this.getName());
            }
            catch (ConnectorException connectorException) {
                // empty catch block
            }
        }
    }

    private class DataListener
    extends AbstractConnectorListener {
        private DataListener() {
        }

        public void messageReceived(ConnectorMessageEvent event) {
            String dataHeader;
            String streamsHeader;
            String message = event.getMessage();
            if (message.startsWith(streamsHeader = "APPLICATION " + Application.this.getName() + " STREAMS ")) {
                String streamIds = message.substring(streamsHeader.length());
                Application.this.fireStreamEvents(streamIds);
            }
            if (message.startsWith(dataHeader = "APPLICATION " + Application.this.getName() + " ")) {
                this.handleData(message.substring(dataHeader.length()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleData(String dataResponse) {
            block11: {
                try {
                    if (this.isReceivedText(dataResponse)) {
                        String data = dataResponse.substring("RECEIVED ".length());
                        String streamId = data.substring(0, data.indexOf(61));
                        String dataHeader = "ALTER APPLICATION " + Application.this.getName() + " READ " + streamId;
                        String response = Connector.getInstance().executeWithId(dataHeader, dataHeader);
                        Utils.checkError(response);
                        String text = response.substring(dataHeader.length() + 1);
                        Map map = Application.this.streams;
                        synchronized (map) {
                            if (Application.this.streams.containsKey(streamId)) {
                                ((Stream)Application.this.streams.get(streamId)).fireTextReceived(text);
                            }
                            break block11;
                        }
                    }
                    if (!this.isReceivedDatagram(dataResponse)) break block11;
                    String data = dataResponse.substring("DATAGRAM ".length());
                    String streamId = data.substring(0, data.indexOf(32));
                    String datagram = data.substring(data.indexOf(32) + 1);
                    Map map = Application.this.streams;
                    synchronized (map) {
                        if (Application.this.streams.containsKey(streamId)) {
                            ((Stream)Application.this.streams.get(streamId)).fireDatagramReceived(datagram);
                        }
                    }
                }
                catch (Exception e) {
                    Utils.handleUncaughtException(e, Application.this.exceptionHandler);
                }
            }
        }

        private boolean isReceivedText(String dataResponse) {
            return dataResponse.startsWith("RECEIVED ") && "RECEIVED ".length() < dataResponse.length();
        }

        private boolean isReceivedDatagram(String dataResponse) {
            return dataResponse.startsWith("DATAGRAM ");
        }
    }
}

