/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import hudson.Extension;
import hudson.model.Queue;
import hudson.model.RootAction;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.shelveproject.DeleteProjectTask;
import org.jvnet.hudson.plugins.shelveproject.ShelvedProject;
import org.jvnet.hudson.plugins.shelveproject.UnshelveProjectTask;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
@Extension
public class ShelvedProjectsAction
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(ShelvedProjectsAction.class.getName());
    static final String SHELVED_PROJECTS_DIRECTORY = "shelvedProjects";
    private static final String ACTION_ICON_PATH = "/plugin/shelve-project-plugin/icons/shelve-project-icon.png";
    private static final Permission UNSHELVE_PERMISSION = Jenkins.ADMINISTER;

    public String getIconFileName() {
        return ShelvedProjectsAction.getUnshelveIconPath();
    }

    private static String getUnshelveIconPath() {
        return Jenkins.getInstance().hasPermission(UNSHELVE_PERMISSION) ? ACTION_ICON_PATH : null;
    }

    public String getDisplayName() {
        return "Shelved Projects";
    }

    public String getUrlName() {
        return "/shelvedProjects";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported
    public List<ShelvedProject> getShelvedProjects() {
        Jenkins.getInstance().checkPermission(UNSHELVE_PERMISSION);
        Path rootPath = Jenkins.getInstance().getRootDir().toPath();
        final LinkedList<ShelvedProject> projects = new LinkedList<ShelvedProject>();
        try {
            Path shelvedProjectRoot = rootPath.resolve(SHELVED_PROJECTS_DIRECTORY);
            if (!Files.exists(shelvedProjectRoot, new LinkOption[0])) {
                Files.createDirectory(shelvedProjectRoot, new FileAttribute[0]);
            }
            final PathMatcher legacyMatcher = FileSystems.getDefault().getPathMatcher("glob:**/*.zip");
            final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**/*.tar");
            Files.walkFileTree(shelvedProjectRoot, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    super.visitFile(file, attrs);
                    if (legacyMatcher.matches(file)) {
                        projects.add(ShelvedProjectsAction.this.getLegacyShelvedProjectFromArchive(file.toFile()));
                    } else if (matcher.matches(file)) {
                        projects.add(ShelvedProjectsAction.this.getShelvedProjectFromArchive(file.toFile()));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not get the list of shelved projects", e);
        }
        finally {
            this.sortProjectsAlphabetically(projects);
        }
        return projects;
    }

    private void sortProjectsAlphabetically(List<ShelvedProject> projects) {
        final Collator collator = Collator.getInstance();
        Collections.sort(projects, new Comparator<ShelvedProject>(){

            @Override
            public int compare(ShelvedProject project1, ShelvedProject project2) {
                return collator.compare(project1.getProjectName(), project2.getProjectName());
            }
        });
    }

    private ShelvedProject getShelvedProjectFromArchive(File archive) {
        return ShelvedProject.createFromTar(archive);
    }

    private ShelvedProject getLegacyShelvedProjectFromArchive(File archive) {
        ShelvedProject shelvedProject = new ShelvedProject();
        shelvedProject.setProjectName(StringUtils.substringBeforeLast((String)archive.getName(), (String)"-"));
        shelvedProject.setTimestamp(Long.parseLong(StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)archive.getName(), (String)"-"), (String)".")));
        shelvedProject.setArchive(archive);
        shelvedProject.setFormatedDate(ShelvedProjectsAction.formatDate(shelvedProject.getTimestamp()));
        return shelvedProject;
    }

    public HttpResponse doManageShelvedProject(StaplerRequest request, StaplerResponse response) throws IOException, ServletException {
        if (request.hasParameter("unshelve")) {
            return this.unshelveProject(request);
        }
        if (request.hasParameter("delete")) {
            return this.deleteProject(request);
        }
        return this.createRedirectToShelvedProjectsPage();
    }

    private HttpResponse unshelveProject(StaplerRequest request) {
        Jenkins.getInstance().checkPermission(UNSHELVE_PERMISSION);
        String[] archives = request.getParameterValues("archives");
        if (archives == null) {
            return this.createRedirectToShelvedProjectsPage();
        }
        LOGGER.info("Unshelving archived projects.");
        Jenkins.getInstance().getQueue().schedule((Queue.Task)new UnshelveProjectTask(archives), 0);
        return this.createRedirectToMainPage();
    }

    private HttpResponse deleteProject(StaplerRequest request) {
        Jenkins.getInstance().checkPermission(UNSHELVE_PERMISSION);
        String[] archives = request.getParameterValues("archives");
        if (archives == null) {
            return this.createRedirectToShelvedProjectsPage();
        }
        LOGGER.info("Deleting archived projects.");
        Jenkins.getInstance().getQueue().schedule((Queue.Task)new DeleteProjectTask(archives), 0);
        return this.createRedirectToShelvedProjectsPage();
    }

    public static String formatDate(long timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        return simpleDateFormat.format(new Date(timestamp));
    }

    private HttpResponse createRedirectToShelvedProjectsPage() {
        return new HttpRedirect(Jenkins.getInstance().getRootUrl() + this.getUrlName());
    }

    private HttpRedirect createRedirectToMainPage() {
        return new HttpRedirect(Jenkins.getInstance().getRootUrl());
    }
}

