/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.jvnet.hudson.plugins.shelveproject.ShelvedProjectsAction;

public class ShelvedProject {
    private static final Logger LOGGER = Logger.getLogger(ShelvedProject.class.getName());
    private String projectName;
    private File archive;
    private long timestamp;
    private String formatedDate;

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getFormatedDate() {
        return this.formatedDate;
    }

    public void setFormatedDate(String formatedDate) {
        this.formatedDate = formatedDate;
    }

    static ShelvedProject createFromTar(File archive) {
        ShelvedProject shelvedProject = new ShelvedProject();
        try {
            Properties shelveProperties = ShelvedProject.loadMetadata(archive);
            shelvedProject.setTimestamp(Long.parseLong(shelveProperties.getProperty("archive.time")));
            shelvedProject.setArchive(archive);
            shelvedProject.setFormatedDate(ShelvedProjectsAction.formatDate(shelvedProject.getTimestamp()));
            shelvedProject.setProjectName(shelveProperties.getProperty("project.fullname"));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not load the archive properly for " + archive, e);
        }
        return shelvedProject;
    }

    static Properties loadMetadata(File archive) throws IOException {
        Path metadataPath = ShelvedProject.getMetadataFileFromArchive(archive);
        Properties shelveProperties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(metadataPath);){
            shelveProperties.load(reader);
        }
        return shelveProperties;
    }

    static Path getMetadataFileFromArchive(File archive) {
        return Paths.get(FilenameUtils.getFullPath((String)archive.getAbsolutePath()), FilenameUtils.getBaseName((String)archive.getAbsolutePath()) + "." + "properties");
    }
}

