/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.FilePath;
import hudson.Plugin;
import hudson.model.AbstractProject;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.util.DirScanner;
import hudson.util.io.ArchiverFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

public class ShelveProjectExecutable
implements Queue.Executable {
    private static final Logger LOGGER = Logger.getLogger(ShelveProjectExecutable.class.getName());
    private static final String[] SYMLINK_EXCLUSION = new String[]{"**/lastFailedBuild/**", "**/lastSuccessfulBuild/**", "**/lastUnsuccessfulBuild/**", "**/lastStableBuild/**", "**/lastUnstableBuild/**", "**/lastFailed/**", "**/lastSuccessful/**", "**/lastUnsuccessful/**", "**/lastStable/**", "**/lastUnstable/**"};
    static final String METADATA_FILE_EXTENSION = "properties";
    static final String ARCHIVE_FILE_EXTENSION = "tar";
    static final String PROJECT_PATH_PROPERTY = "project.path";
    static final String PROJECT_FULL_NAME_PROPERTY = "project.fullname";
    static final String PROJECT_NAME_PROPERTY = "project.name";
    static final String ARCHIVE_TIME_PROPERTY = "archive.time";
    static final String ARCHIVE_COMPRESSION = "archive.compression";
    private final Item item;
    private final Queue.Task parentTask;

    public ShelveProjectExecutable(Queue.Task parentTask, Item item) {
        this.parentTask = parentTask;
        this.item = item;
    }

    public Queue.Task getParent() {
        return this.parentTask;
    }

    public void run() {
        if (this.archiveProject()) {
            this.deleteProject();
        }
    }

    public long getEstimatedDuration() {
        return -1L;
    }

    public String getTimestampString() {
        Executor executor = Executor.of((Queue.Executable)this);
        if (executor != null) {
            return executor.getTimestampString();
        }
        return "N/A";
    }

    private boolean archiveProject() {
        this.wipeoutWorkspace();
        LOGGER.info("Creating archive for project [" + this.item.getName() + "].");
        try {
            Path projectRootPath = this.item.getRootDir().toPath();
            List<String> regexp = this.createListOfFoldersToBackup();
            regexp.add(this.relativizeToJenkinsJobsDirectory(projectRootPath) + "/**/*");
            long archiveTime = System.currentTimeMillis();
            String backupBaseName = this.item.getName() + "-" + archiveTime;
            Path rootPath = Jenkins.getInstance().getRootDir().toPath();
            Path shelvedProjectRoot = rootPath.resolve("shelvedProjects");
            if (!Files.exists(shelvedProjectRoot, new LinkOption[0])) {
                Files.createDirectory(shelvedProjectRoot, new FileAttribute[0]);
            }
            this.buildMetadataFile(shelvedProjectRoot, backupBaseName, archiveTime);
            Path archivePath = Files.createFile(shelvedProjectRoot.resolve(backupBaseName + "." + ARCHIVE_FILE_EXTENSION), new FileAttribute[0]);
            FilePath destinationPath = new FilePath(archivePath.toFile());
            ShelveProjectExecutable.tar(new FilePath(this.getJenkinsJobsDirectory()), destinationPath, String.join((CharSequence)",", regexp), this.buildExclusionGlob());
            return true;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Could not archive project [" + this.item.getName() + "].", e);
            return false;
        }
    }

    private String buildExclusionGlob() {
        return String.join((CharSequence)",", SYMLINK_EXCLUSION);
    }

    private void buildMetadataFile(Path shelvedProjectRoot, String backupBaseName, long archiveTime) throws IOException {
        Path archivePath = Files.createFile(shelvedProjectRoot.resolve(backupBaseName + "." + METADATA_FILE_EXTENSION), new FileAttribute[0]);
        Path projectRootPath = this.item.getRootDir().toPath();
        try (BufferedWriter writer = Files.newBufferedWriter(archivePath, Charset.forName("UTF-8"), new OpenOption[0]);){
            ShelveProjectExecutable.addNewProperty(writer, PROJECT_PATH_PROPERTY, ShelveProjectExecutable.escapeForPropertiesFile(this.relativizeToJenkinsJobsDirectory(projectRootPath)));
            ShelveProjectExecutable.addNewProperty(writer, PROJECT_NAME_PROPERTY, this.item.getName());
            ShelveProjectExecutable.addNewProperty(writer, ARCHIVE_TIME_PROPERTY, Long.toString(archiveTime));
            ShelveProjectExecutable.addNewProperty(writer, PROJECT_FULL_NAME_PROPERTY, this.item.getFullName());
            ShelveProjectExecutable.addNewProperty(writer, ARCHIVE_COMPRESSION, "true");
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not write metadata for project [" + this.item.getName() + "].", e);
            throw e;
        }
    }

    private static String escapeForPropertiesFile(@Nonnull String path) {
        return path.replaceAll("\\\\", Matcher.quoteReplacement("\\\\"));
    }

    private static void addNewProperty(BufferedWriter writer, String key, String value) throws IOException {
        writer.write(key + "=" + value);
        writer.newLine();
    }

    private static void tar(FilePath origin, FilePath dst, String includes, String excludes) throws IOException, InterruptedException {
        try (OutputStream os = dst.write();){
            origin.archive(ArchiverFactory.TARGZ, os, (DirScanner)new DirScanner.Glob(includes, excludes));
        }
    }

    private List<String> createListOfFoldersToBackup() {
        ArrayList<String> regexp = new ArrayList<String>();
        Plugin folderPlugin = Jenkins.getInstance().getPlugin("cloudbees-folder");
        if (folderPlugin != null && folderPlugin.getWrapper().isActive()) {
            ItemGroup parent = this.item.getParent();
            while (parent instanceof AbstractFolder) {
                LOGGER.log(Level.INFO, "Archiving parent folder: " + parent.getFullName());
                Path absoluteFolderConfigPath = parent.getRootDir().toPath().resolve("config.xml");
                regexp.add(this.relativizeToJenkinsJobsDirectory(absoluteFolderConfigPath));
                parent = ((AbstractFolder)parent).getParent();
            }
        }
        return regexp;
    }

    private String relativizeToJenkinsJobsDirectory(Path path) {
        return this.getJenkinsJobsDirectory().toPath().relativize(path).toString();
    }

    private File getJenkinsJobsDirectory() {
        return new File(Jenkins.getInstance().getRootDir(), "jobs");
    }

    private void wipeoutWorkspace() {
        LOGGER.info("Wiping out workspace for project [" + this.item.getName() + "].");
        try {
            if (this.item instanceof AbstractProject) {
                ((AbstractProject)this.item).doDoWipeOutWorkspace();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not wipeout workspace [" + this.item.getName() + "].", e);
        }
    }

    private void deleteProject() {
        LOGGER.info("Deleting project [" + this.item.getName() + "].");
        try {
            this.item.delete();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not delete project [" + this.item.getName() + "].", e);
        }
    }

    public String toString() {
        return "Shelving " + this.item.getName();
    }
}

