/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.shelveproject;

import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.security.Permission;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jvnet.hudson.plugins.shelveproject.ShelveProjectTask;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;

public class ShelveProjectAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(ShelveProjectAction.class.getName());
    private static final Permission SHELVE_PERMISSION = Item.DELETE;
    private Item item;
    private boolean isShelvingProject;
    private static final String ACTION_ICON_PATH = "/plugin/shelve-project-plugin/icons/shelve-project-icon.png";

    public ShelveProjectAction(Item item) {
        this.item = item;
        this.isShelvingProject = false;
    }

    public String getIconFileName() {
        return ShelveProjectAction.getShelveIconPath();
    }

    private static String getShelveIconPath() {
        return Jenkins.getInstance().hasPermission(SHELVE_PERMISSION) ? ACTION_ICON_PATH : null;
    }

    public String getDisplayName() {
        return "Shelve Project";
    }

    public String getUrlName() {
        return "shelve";
    }

    public Item getItem() {
        return this.item;
    }

    public boolean isShelvingProject() {
        return this.isShelvingProject;
    }

    public HttpResponse doShelveProject() throws IOException, ServletException {
        Jenkins.getInstance().checkPermission(Item.DELETE);
        if (!this.isShelvingProject()) {
            LOGGER.info("Shelving project [" + this.getItem().getName() + "].");
            Jenkins.getInstance().getQueue().schedule((Queue.Task)new ShelveProjectTask(this.item), 0);
        }
        return this.createRedirectToMainPage();
    }

    private HttpRedirect createRedirectToMainPage() {
        return new HttpRedirect(Jenkins.getInstance().getRootUrl());
    }
}

