/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributor;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributorDescriptor;
import org.jenkinsci.plugins.sharedobjects.MultipleSharedObjectType;
import org.jenkinsci.plugins.sharedobjects.SharedObjectException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectType;
import org.jenkinsci.plugins.sharedobjects.SimpleSharedObjectType;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectDataStore;
import org.jenkinsci.plugins.sharedobjects.service.SharedObjectLogger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObjectJobProperty
extends EnvInjectJobPropertyContributor {
    private boolean populateSharedObjects;
    private String profiles;

    public SharedObjectJobProperty() {
    }

    @DataBoundConstructor
    public SharedObjectJobProperty(boolean populateSharedObjects, String profiles) {
        this.populateSharedObjects = populateSharedObjects;
        this.profiles = Util.fixEmptyAndTrim((String)profiles);
    }

    public boolean isPopulateSharedObjects() {
        return this.populateSharedObjects;
    }

    public String getProfiles() {
        return this.profiles;
    }

    public void init() {
        this.populateSharedObjects = false;
    }

    public Map<String, String> getEnvVars(AbstractBuild build, TaskListener listener) throws EnvInjectException {
        SharedObjectLogger logger = new SharedObjectLogger(listener);
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.populateSharedObjects) {
            logger.info("Injecting shared objects as environment variables");
            try {
                SharedObjectType[] sharedObjectTypes = (SharedObjectType[])Hudson.getInstance().getRootPath().act((Callable)new Callable<SharedObjectType[], EnvInjectException>(){

                    public SharedObjectType[] call() throws EnvInjectException {
                        SharedObjectDataStore dataStore = new SharedObjectDataStore();
                        try {
                            return dataStore.readSharedObjectsFile();
                        }
                        catch (SharedObjectException e) {
                            throw new EnvInjectException((Throwable)e);
                        }
                    }
                });
                if (sharedObjectTypes != null) {
                    boolean restrictionActivated = true;
                    if (this.profiles == null || this.profiles.trim().length() == 0) {
                        restrictionActivated = false;
                    }
                    if (restrictionActivated) {
                        logger.info(String.format("Restricting shared objects to the following usage %s", this.profiles));
                    }
                    for (SharedObjectType type : sharedObjectTypes) {
                        if (type == null) continue;
                        if (!restrictionActivated) {
                            this.addSharedObject(result, type, build, logger);
                            continue;
                        }
                        if (!restrictionActivated || !this.isProfileActivated(this.profiles, type)) continue;
                        this.addSharedObject(result, type, build, logger);
                    }
                }
            }
            catch (SharedObjectException se) {
                throw new EnvInjectException((Throwable)se);
            }
            catch (IOException e) {
                throw new EnvInjectException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new EnvInjectException((Throwable)e);
            }
        }
        return result;
    }

    private void addSharedObject(Map<String, String> result, SharedObjectType type, AbstractBuild build, SharedObjectLogger logger) throws SharedObjectException {
        if (type instanceof SimpleSharedObjectType) {
            SimpleSharedObjectType simpleSharedObjectType = (SimpleSharedObjectType)type;
            String value = simpleSharedObjectType.getEnvVarValue(build, logger);
            if (value != null) {
                result.put(simpleSharedObjectType.getName(), value);
            }
            return;
        }
        if (type instanceof MultipleSharedObjectType) {
            MultipleSharedObjectType multipleSharedObjectType = (MultipleSharedObjectType)type;
            Map<String, String> envVars = multipleSharedObjectType.getEnvVarValue(build, logger);
            if (envVars != null) {
                result.putAll(envVars);
            }
            return;
        }
    }

    private boolean isProfileActivated(String profiles, SharedObjectType type) {
        String profilesType = type.getProfiles();
        if (profilesType == null) {
            return true;
        }
        if (profilesType.length() == 0) {
            return true;
        }
        String[] profilesTypeArray = profilesType.split(";");
        List<String> profilesJobs = Arrays.asList(profiles.split(";"));
        for (String profileType : profilesTypeArray) {
            if (!profilesJobs.contains(profileType)) continue;
            return true;
        }
        return false;
    }

    @Extension
    public static class SharedObjectJobPropertyDescriptor
    extends EnvInjectJobPropertyContributorDescriptor {
        public String getDisplayName() {
            return "Populate shared objects";
        }
    }
}

