/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sharedobjects.service;

import hudson.model.Hudson;
import hudson.util.XStream2;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.jenkinsci.plugins.sharedobjects.SharedObjectsException;
import org.jenkinsci.plugins.sharedobjects.SharedObjectsManagement;
import org.jenkinsci.plugins.sharedobjects.SharedObjectsType;

public class SharedObjectsDataStore {
    public void writeSharedObjectsFile(SharedObjectsType[] types) throws SharedObjectsException {
        XStream2 xStream2 = new XStream2();
        File sharedObjectsFile = new File(Hudson.getInstance().getRootDir(), "sharedObjects.xml");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(sharedObjectsFile, false);
            xStream2.toXML((Object)new SharedObjectsManagement(types), (Writer)fileWriter);
        }
        catch (IOException e) {
            throw new SharedObjectsException(e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    throw new SharedObjectsException(e);
                }
            }
        }
    }

    public SharedObjectsType[] readSharedObjectsFile() throws SharedObjectsException {
        XStream2 xStream2 = new XStream2();
        File sharedObjectsFile = new File(Hudson.getInstance().getRootDir(), "sharedObjects.xml");
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(sharedObjectsFile);
            if (sharedObjectsFile.exists()) {
                SharedObjectsManagement sharedObjectsManagement = (SharedObjectsManagement)((Object)xStream2.fromXML((Reader)fileReader));
                SharedObjectsType[] sharedObjectsTypeArray = sharedObjectsManagement.getTypes();
                return sharedObjectsTypeArray;
            }
        }
        catch (FileNotFoundException e) {
            throw new SharedObjectsException(e);
        }
        catch (IOException e) {
            throw new SharedObjectsException(e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    throw new SharedObjectsException(e);
                }
            }
        }
        return new SharedObjectsType[0];
    }
}

