/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.seleniumhtmlreport;

import hudson.FilePath;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Run;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import jenkins.model.RunAction2;
import org.jvnet.hudson.plugins.seleniumhtmlreport.TestResult;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class SeleniumHtmlReportAction
implements Action,
Serializable,
RunAction2 {
    private transient Run<?, ?> build;
    private final List<TestResult> results;
    private final File seleniumReportsDir;

    public SeleniumHtmlReportAction(List<TestResult> results, File seleniumReportsDir) {
        this.results = results;
        this.seleniumReportsDir = seleniumReportsDir;
    }

    public String getIconFileName() {
        return "/plugin/seleniumhtmlreport/icons/sla-48x48.png";
    }

    public String getDisplayName() {
        return "Selenium Html Report";
    }

    public String getUrlName() {
        return "seleniumhtmlreport";
    }

    public Run<?, ?> getOwner() {
        return this.build;
    }

    public List<TestResult> getResults() {
        return this.results;
    }

    public int getSumTestPasses() {
        return this.calculateSumOf(new TestResultValueProvider(){

            @Override
            public int getValueOf(TestResult result) {
                return result.getNumTestPasses();
            }
        });
    }

    public void onAttached(Run<?, ?> build) {
        this.build = build;
    }

    public void onLoad(Run<?, ?> build) {
        this.build = build;
    }

    protected int calculateSumOf(TestResultValueProvider values) {
        int sum = 0;
        for (TestResult r : this.results) {
            sum += values.getValueOf(r);
        }
        return sum;
    }

    public int getSumTestFailures() {
        return this.calculateSumOf(new TestResultValueProvider(){

            @Override
            public int getValueOf(TestResult result) {
                return result.getNumTestFailures();
            }
        });
    }

    public int getSumCommandPasses() {
        return this.calculateSumOf(new TestResultValueProvider(){

            @Override
            public int getValueOf(TestResult result) {
                return result.getNumCommandPasses();
            }
        });
    }

    public int getSumCommandFailures() {
        return this.calculateSumOf(new TestResultValueProvider(){

            @Override
            public int getValueOf(TestResult result) {
                return result.getNumCommandFailures();
            }
        });
    }

    public int getSumCommandErrors() {
        return this.calculateSumOf(new TestResultValueProvider(){

            @Override
            public int getValueOf(TestResult result) {
                return result.getNumCommandErrors();
            }
        });
    }

    public int getSumTestTotal() {
        return this.calculateSumOf(new TestResultValueProvider(){

            @Override
            public int getValueOf(TestResult result) {
                return result.getNumTestTotal();
            }
        });
    }

    public int getTotalTime() {
        return this.calculateSumOf(new TestResultValueProvider(){

            @Override
            public int getValueOf(TestResult result) {
                return result.getTotalTime();
            }
        });
    }

    public DirectoryBrowserSupport doDynamic(StaplerRequest req, StaplerResponse rsp) {
        if (this.build != null) {
            return new DirectoryBrowserSupport((ModelObject)this, new FilePath(this.seleniumReportsDir), "seleniumhtmlreport", "clipboard.gif", false);
        }
        return null;
    }

    protected static interface TestResultValueProvider {
        public int getValueOf(TestResult var1);
    }
}

