/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.process;

import hudson.plugins.selenium.process.ProcessArgument;
import hudson.plugins.selenium.process.ProcessKeyListArgument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public final class SeleniumRunOptions
implements Serializable {
    private static final long serialVersionUID = -5571585840451096944L;
    private List<ProcessArgument> arguments = new ArrayList<ProcessArgument>();
    private Map<String, String> jvmArgs = new HashMap<String, String>();
    private Map<String, String> envVars = new HashMap<String, String>();

    public List<ProcessArgument> getSeleniumArguments() {
        return this.arguments;
    }

    public Map<String, String> getJVMArguments() {
        return this.jvmArgs;
    }

    public void addOption(String option) {
        this.arguments.add(new ProcessArgument(option));
    }

    public void addOptionIfSet(String option, Object value) {
        if (value != null && StringUtils.hasText((String)value.toString())) {
            this.arguments.add(new ProcessKeyListArgument(option, value.toString()));
        }
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.envVars;
    }

    public void setEnvVar(String key, String value) {
        if (value != null && !value.equals("")) {
            this.envVars.put(key, value);
        }
    }

    public static SeleniumRunOptions merge(SeleniumRunOptions options1, SeleniumRunOptions options2) {
        if (options1 == null && options2 == null) {
            return null;
        }
        SeleniumRunOptions newOpts = new SeleniumRunOptions();
        SeleniumRunOptions.addAllOptions(newOpts, options1);
        SeleniumRunOptions.addAllOptions(newOpts, options2);
        return newOpts;
    }

    private static void addAllOptions(SeleniumRunOptions newOpts, SeleniumRunOptions options) {
        if (options == null) {
            return;
        }
        for (ProcessArgument processArgument : options.arguments) {
            newOpts.arguments.add(processArgument);
        }
        for (Map.Entry entry : options.jvmArgs.entrySet()) {
            newOpts.jvmArgs.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : options.envVars.entrySet()) {
            newOpts.envVars.put((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

