/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.process;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.CommandTransport;
import hudson.remoting.SocketChannelStream;
import hudson.remoting.Which;
import hudson.slaves.Channels;
import hudson.util.ClasspathBuilder;
import hudson.util.JVMBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.openqa.grid.selenium.GridLauncherV3;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public final class SeleniumProcessUtils {
    private static final Logger LOGGER = Logger.getLogger(SeleniumProcessUtils.class.getName());

    private SeleniumProcessUtils() {
    }

    public static File findStandAloneServerJar() throws IOException {
        return Which.jarFile(GridLauncherV3.class);
    }

    public static File findHtmlUnitDriverJar() throws IOException {
        return Which.jarFile(HtmlUnitDriver.class);
    }

    public static Channel createSeleniumGridVM(TaskListener listener) throws IOException {
        JVMBuilder vmb = new JVMBuilder();
        vmb.systemProperties(null);
        return Channels.newJVM((String)"Selenium Grid", (TaskListener)listener, (JVMBuilder)vmb, (FilePath)new FilePath(Jenkins.getInstance().getRootDir()), (ClasspathBuilder)new ClasspathBuilder().add(SeleniumProcessUtils.findStandAloneServerJar()).add(SeleniumProcessUtils.findHtmlUnitDriverJar()));
    }

    public static Channel createSeleniumRCVM(File standaloneServerJar, File htmlUnitDriverJar, TaskListener listener, Map<String, String> properties, Map<String, String> envVariables) throws IOException, InterruptedException {
        String displayName = "Selenium RC";
        ClasspathBuilder classpath = new ClasspathBuilder().add(standaloneServerJar);
        classpath.add(htmlUnitDriverJar);
        JVMBuilder vmb = new JVMBuilder();
        vmb.systemProperties(properties);
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.bind(new InetSocketAddress("localhost", 0));
        serverSocket.setSoTimeout(10000);
        vmb.classpath().addJarOf(Channel.class);
        vmb.mainClass(hudson.remoting.Launcher.class);
        vmb.args().add("-cp").add((Object)classpath);
        vmb.args().add(new String[]{"-connectTo", "localhost:" + serverSocket.getLocalPort()});
        Proc p = vmb.launch((Launcher)new Launcher.LocalLauncher(listener)).stdout(listener).envs(envVariables).start();
        Socket s = serverSocket.accept();
        serverSocket.close();
        return SeleniumProcessUtils.createChannel("Channel to " + displayName, Computer.threadPoolForRemoting, new BufferedInputStream(SocketChannelStream.in((Socket)s)), new BufferedOutputStream(SocketChannelStream.out((Socket)s)), null, p);
    }

    private static Channel createChannel(String name, ExecutorService execService, InputStream in, OutputStream out, OutputStream header, final Proc proc) throws IOException {
        ChannelBuilder cb = new ChannelBuilder(name, execService){

            public Channel build(CommandTransport transport) throws IOException {
                return new Channel(this, transport){

                    public synchronized void terminate(IOException e) {
                        super.terminate(e);
                        try {
                            proc.kill();
                        }
                        catch (IOException x) {
                            LOGGER.log(Level.INFO, "Failed to terminate the severed connection", x);
                        }
                        catch (InterruptedException x) {
                            Thread.currentThread().interrupt();
                        }
                    }

                    public synchronized void join() throws InterruptedException {
                        super.join();
                        try {
                            proc.join();
                        }
                        catch (IOException e) {
                            throw new IOError(e);
                        }
                    }
                };
            }
        };
        cb.withHeaderStream(header);
        return cb.build(in, out);
    }
}

