/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.global.hostname;

import hudson.Extension;
import hudson.plugins.selenium.configuration.global.hostname.HostnameResolver;
import hudson.plugins.selenium.configuration.global.hostname.HostnameResolverDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class JenkinsRootHostnameResolver
extends HostnameResolver {
    private static final long serialVersionUID = 7865004453289102894L;

    @DataBoundConstructor
    public JenkinsRootHostnameResolver() {
    }

    @Override
    public String retrieveHost() {
        URL url;
        String rootUrl = Jenkins.getInstance().getRootUrl();
        if (rootUrl == null) {
            return "localhost";
        }
        try {
            url = new URL(rootUrl);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return url.getHost();
    }

    @Extension
    public static final class JenkinsHostnameRetrieverDescriptor
    extends HostnameResolverDescriptor {
        public String getDisplayName() {
            return "Use jenkins URL, as defined in the global configuration";
        }
    }
}

