/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.browser.selenium;

import hudson.Extension;
import hudson.model.Computer;
import hudson.plugins.selenium.configuration.browser.EdgeDriverServerUtils;
import hudson.plugins.selenium.configuration.browser.selenium.SeleniumBrowser;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class EdgeBrowser
extends SeleniumBrowser {
    private static final long serialVersionUID = 2L;
    private String driverBinaryPath;
    private final transient String edgeDriverProperty = "webdriver.edge.driver";
    @Deprecated
    private transient String server_binary;

    @DataBoundConstructor
    public EdgeBrowser(int maxInstances, String version, String driverBinaryPath) {
        super(maxInstances, version, "*MicrosoftEdge");
        this.driverBinaryPath = driverBinaryPath;
    }

    @Exported
    public String getDriverBinaryPath() {
        return this.driverBinaryPath;
    }

    @Override
    public void initOptions(Computer c, SeleniumRunOptions opt) {
        String serverPath = EdgeDriverServerUtils.uploadEdgeDriverIfNecessary(c, this.getDriverBinaryPath());
        if (serverPath != null) {
            opt.getJVMArguments().put("webdriver.edge.driver", serverPath);
        }
        opt.addOptionIfSet("-browser", StringUtils.join(this.initBrowserOptions(c, opt), (String)","));
    }

    @Deprecated
    public String getServer_binary() {
        return this.server_binary;
    }

    public Object readResolve() {
        if (this.server_binary != null) {
            this.driverBinaryPath = this.server_binary;
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends SeleniumBrowser.SeleniumBrowserDescriptor {
        @Override
        public int getMaxInstances() {
            return 1;
        }

        public String getDisplayName() {
            return "Microsoft Edge";
        }
    }
}

